/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.boot.autoconfigure.jdbc.CustomDataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.datasource")
public class MultipleDataSourceProperties
extends CustomDataSourceProperties {
    public static final String SINGLE_NAME_PLACEHOLDER = "{name}";
    private Map<String, CustomDataSourceProperties> multiple = new HashMap<String, CustomDataSourceProperties>();

    public CustomDataSourceProperties getSingleProperties(String name) {
        CustomDataSourceProperties properties = this.multiple.getOrDefault(name, new CustomDataSourceProperties());
        String pattern = Pattern.quote(SINGLE_NAME_PLACEHOLDER);
        if (StringUtils.hasText((String)properties.getName())) {
            properties.setName(properties.getName().replaceAll(pattern, name));
        }
        if (StringUtils.hasText((String)properties.getUrl())) {
            properties.setUrl(properties.getUrl().replaceAll(pattern, name));
        }
        Map<String, Map<String, Object>> parent = properties.getParameter();
        for (String parentKey : parent.keySet()) {
            Map<String, Object> child = parent.get(parentKey);
            for (String childKey : child.keySet()) {
                Object value = child.get(childKey);
                if (!(value instanceof String)) continue;
                child.put(childKey, ((String)value).replaceAll(pattern, name));
            }
        }
        return properties;
    }

    public Map<String, CustomDataSourceProperties> getMultiple() {
        return this.multiple;
    }

    public void setMultiple(Map<String, CustomDataSourceProperties> multiple) {
        this.multiple = multiple;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultipleDataSourceProperties)) {
            return false;
        }
        MultipleDataSourceProperties other = (MultipleDataSourceProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, CustomDataSourceProperties> this$multiple = this.getMultiple();
        Map<String, CustomDataSourceProperties> other$multiple = other.getMultiple();
        return !(this$multiple == null ? other$multiple != null : !((Object)this$multiple).equals(other$multiple));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MultipleDataSourceProperties;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, CustomDataSourceProperties> $multiple = this.getMultiple();
        result = result * 59 + ($multiple == null ? 43 : ((Object)$multiple).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MultipleDataSourceProperties(super=" + super.toString() + ", multiple=" + this.getMultiple() + ")";
    }
}

