/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import lombok.NonNull;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.jpa.boot.spi.IntegratorProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.orm.jpa.CustomJpaProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.jdbc.SchemaManagementProvider;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.StringUtils;

@Configuration
public class CustomHibernateJpaConfiguration
extends HibernateJpaConfiguration {
    private CustomJpaProperties jpaProperties;
    private IntegratorProvider integratorProvider;

    public CustomHibernateJpaConfiguration(DataSource dataSource, @NonNull CustomJpaProperties jpaProperties, ObjectProvider<JtaTransactionManager> jtaTransactionManager, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers, ObjectProvider<Collection<DataSourcePoolMetadataProvider>> metadataProviders, ObjectProvider<List<SchemaManagementProvider>> schemaManagementProviders, ObjectProvider<PhysicalNamingStrategy> physicalNamingStrategy, ObjectProvider<ImplicitNamingStrategy> implicitNamingStrategy, @NonNull ObjectProvider<IntegratorProvider> integratorProvider, ObjectProvider<List<HibernatePropertiesCustomizer>> hibernatePropertiesCustomizers) {
        super(dataSource, (JpaProperties)jpaProperties, jtaTransactionManager, transactionManagerCustomizers, metadataProviders, schemaManagementProviders, physicalNamingStrategy, implicitNamingStrategy, hibernatePropertiesCustomizers);
        if (jpaProperties == null) {
            throw new NullPointerException("jpaProperties is marked @NonNull but is null");
        }
        if (integratorProvider == null) {
            throw new NullPointerException("integratorProvider is marked @NonNull but is null");
        }
        this.jpaProperties = jpaProperties;
        this.integratorProvider = (IntegratorProvider)integratorProvider.getIfAvailable();
    }

    @Bean
    public PlatformTransactionManager transactionManager() {
        JpaTransactionManager transactionManager = (JpaTransactionManager)super.transactionManager();
        String persistenceUnitName = this.jpaProperties.getPersistenceUnitName();
        if (StringUtils.hasText((String)persistenceUnitName)) {
            transactionManager.setPersistenceUnitName(persistenceUnitName);
        }
        return transactionManager;
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(EntityManagerFactoryBuilder builder) {
        LocalContainerEntityManagerFactoryBean factory = super.entityManagerFactory(builder);
        String persistenceUnitName = this.jpaProperties.getPersistenceUnitName();
        if (StringUtils.hasText((String)persistenceUnitName)) {
            factory.setPersistenceUnitName(persistenceUnitName);
        }
        return factory;
    }

    protected void customizeVendorProperties(@NonNull Map<String, Object> vendorProperties) {
        if (vendorProperties == null) {
            throw new NullPointerException("vendorProperties is marked @NonNull but is null");
        }
        super.customizeVendorProperties(vendorProperties);
        if (this.integratorProvider != null) {
            vendorProperties.put("hibernate.integrator_provider", this.integratorProvider);
        }
    }
}

