/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.sql.DataSource;
import lombok.NonNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.jdbc.MultipleDataSourceConfigurerAdapter;
import org.springframework.boot.autoconfigure.orm.jpa.CustomHibernateJpaConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.CustomHibernateJpaConfigurationBuilder;
import org.springframework.boot.autoconfigure.orm.jpa.CustomJpaProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaConfigurationBuilderConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.MultipleJpaConfigurer;
import org.springframework.boot.autoconfigure.orm.jpa.MultipleJpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

@Configuration
@EnableConfigurationProperties(value={MultipleJpaProperties.class})
@Import(value={HibernateJpaConfigurationBuilderConfiguration.class})
public abstract class MultipleJpaConfigurerAdapter
extends MultipleDataSourceConfigurerAdapter
implements MultipleJpaConfigurer {
    public static final String TRANSACTION_MANAGER_BEAN_SUFFIX = "TransactionManager";
    public static final String ENTITY_MANAGER_FACTORY_BEAN_SUFFIX = "EntityManagerFactory";
    private CustomHibernateJpaConfigurationBuilder configBuilder;
    private MultipleJpaProperties jpaProperties;

    protected CustomHibernateJpaConfigurationBuilder getConfigBuilder() {
        Assert.notNull((Object)this.configBuilder, (String)"Field 'configBuilder' must be set");
        return this.configBuilder;
    }

    protected MultipleJpaProperties getMultipleJpaProperties() {
        Assert.notNull((Object)((Object)this.jpaProperties), (String)"Field 'jpaProperties' must be set");
        return this.jpaProperties;
    }

    protected CustomJpaProperties getSingleJpaProperties(String name) {
        return this.getMultipleJpaProperties().getSingleJpaProperties(name);
    }

    @Override
    public void setBeanFactory(@NonNull BeanFactory beanFactory) throws BeansException {
        if (beanFactory == null) {
            throw new NullPointerException("beanFactory is marked @NonNull but is null");
        }
        super.setBeanFactory(beanFactory);
        this.configBuilder = (CustomHibernateJpaConfigurationBuilder)beanFactory.getBean(CustomHibernateJpaConfigurationBuilder.class);
        this.jpaProperties = (MultipleJpaProperties)((Object)beanFactory.getBean(MultipleJpaProperties.class));
    }

    @Override
    public DataSource dataSource() {
        return super.dataSource();
    }

    @Override
    public PlatformTransactionManager transactionManager() {
        return this.createTransactionManager(this.determineSingleName(TRANSACTION_MANAGER_BEAN_SUFFIX));
    }

    @Override
    public LocalContainerEntityManagerFactoryBean entityManagerFactory() {
        return this.createEntityManagerFactory(this.determineSingleName(TRANSACTION_MANAGER_BEAN_SUFFIX));
    }

    protected PlatformTransactionManager createTransactionManager(String name) {
        return this.createConfig(name).transactionManager();
    }

    protected LocalContainerEntityManagerFactoryBean createEntityManagerFactory(String name) {
        CustomHibernateJpaConfiguration config = this.createConfig(name);
        EntityManagerFactoryBuilder factoryBuilder = config.entityManagerFactoryBuilder(config.jpaVendorAdapter(), new XSimpleObjectProvider<PersistenceUnitManager>(this.persistenceUnitManager()));
        LocalContainerEntityManagerFactoryBean factory = config.entityManagerFactory(factoryBuilder);
        LinkedHashSet<String> packagesToScan = new LinkedHashSet<String>();
        packagesToScan.addAll(this.basePackages());
        if (this.basePackageClass() != null) {
            packagesToScan.add(ClassUtils.getPackageName(this.basePackageClass()));
        }
        for (Class<?> basePackageClass : this.basePackageClasses()) {
            packagesToScan.add(ClassUtils.getPackageName(basePackageClass));
        }
        if (!CollectionUtils.isEmpty(packagesToScan)) {
            factory.setPackagesToScan(packagesToScan.toArray(new String[0]));
        }
        return factory;
    }

    protected CustomHibernateJpaConfiguration createConfig(String name) {
        return this.configBuilder.build(this.dataSource(), this.getSingleJpaProperties(name));
    }

    protected PersistenceUnitManager persistenceUnitManager() {
        return null;
    }

    protected Collection<String> basePackages() {
        return Collections.emptyList();
    }

    protected Class<?> basePackageClass() {
        return null;
    }

    protected Collection<Class<?>> basePackageClasses() {
        return Collections.emptyList();
    }

    protected static class XSimpleObjectProvider<T>
    implements ObjectProvider<T> {
        private final T bean;

        public T getObject() {
            throw new UnsupportedOperationException();
        }

        public T getObject(Object ... args) {
            throw new UnsupportedOperationException();
        }

        public T getIfAvailable() {
            return this.bean;
        }

        public T getIfUnique() {
            throw new UnsupportedOperationException();
        }

        public XSimpleObjectProvider(T bean) {
            this.bean = bean;
        }
    }
}

