/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import jetbrick.collection.ListUtils;
import jetbrick.typecast.Convertor;
import jetbrick.typecast.support.ArrayConvertor;
import jetbrick.typecast.support.BooleanConvertor;
import jetbrick.typecast.support.ByteConvertor;
import jetbrick.typecast.support.CharacterConvertor;
import jetbrick.typecast.support.DoubleConvertor;
import jetbrick.typecast.support.FloatConvertor;
import jetbrick.typecast.support.IntegerConvertor;
import jetbrick.typecast.support.LongConvertor;
import jetbrick.typecast.support.ShortConvertor;
import jetbrick.util.StringUtils;

public final class PrimitiveArrayConvertor<T>
implements Convertor<T> {
    public static final PrimitiveArrayConvertor<byte[]> BYTE_ARRAY_CONVERTOR = new PrimitiveArrayConvertor(Byte.TYPE);
    public static final PrimitiveArrayConvertor<short[]> SHORT_ARRAY_CONVERTOR = new PrimitiveArrayConvertor(Short.TYPE);
    public static final PrimitiveArrayConvertor<int[]> INTEGER_ARRAY_CONVERTOR = new PrimitiveArrayConvertor(Integer.TYPE);
    public static final PrimitiveArrayConvertor<long[]> LONG_ARRAY_CONVERTOR = new PrimitiveArrayConvertor(Long.TYPE);
    public static final PrimitiveArrayConvertor<float[]> FLOAT_ARRAY_CONVERTOR = new PrimitiveArrayConvertor(Float.TYPE);
    public static final PrimitiveArrayConvertor<double[]> DOUBLE_ARRAY_CONVERTOR = new PrimitiveArrayConvertor(Double.TYPE);
    public static final PrimitiveArrayConvertor<char[]> CHAR_ARRAY_CONVERTOR = new PrimitiveArrayConvertor(Character.TYPE);
    public static final PrimitiveArrayConvertor<boolean[]> BOOLEAN_ARRAY_CONVERTOR = new PrimitiveArrayConvertor(Boolean.TYPE);
    private final Class<?> elementType;

    public PrimitiveArrayConvertor(Class<?> elementType) {
        this.elementType = elementType;
    }

    @Override
    public T convert(String value) {
        if (value == null) {
            return null;
        }
        Object[] values = StringUtils.split(value.toString(), ',');
        return this.convertToArray(values);
    }

    @Override
    public T convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (this.elementType == value.getClass().getComponentType()) {
                return (T)value;
            }
            Object[] arrays = ArrayConvertor.toObjectArray(value);
            return this.convertToArray(arrays);
        }
        if (value instanceof Iterable) {
            List results = ListUtils.asList((Iterable)value);
            return this.convertToArray(results.toArray());
        }
        if (value instanceof Iterator) {
            List results = ListUtils.asList((Iterator)value);
            return this.convertToArray(results.toArray());
        }
        if (value instanceof Enumeration) {
            List results = ListUtils.asList((Enumeration)value);
            return this.convertToArray(results.toArray());
        }
        return this.convert(value.toString());
    }

    private T convertToArray(Object[] arrays) {
        if (this.elementType == Integer.TYPE) {
            return (T)this.convertToIntArray(arrays);
        }
        if (this.elementType == Long.TYPE) {
            return (T)this.convertToLongArray(arrays);
        }
        if (this.elementType == Float.TYPE) {
            return (T)this.convertToFloatArray(arrays);
        }
        if (this.elementType == Double.TYPE) {
            return (T)this.convertToDoubleArray(arrays);
        }
        if (this.elementType == Boolean.TYPE) {
            return (T)this.convertToBooleanArray(arrays);
        }
        if (this.elementType == Byte.TYPE) {
            return (T)this.convertToByteArray(arrays);
        }
        if (this.elementType == Short.TYPE) {
            return (T)this.convertToShortArray(arrays);
        }
        if (this.elementType == Character.TYPE) {
            return (T)this.convertToCharArray(arrays);
        }
        throw new IllegalStateException("Unreachable code");
    }

    private int[] convertToIntArray(Object[] items) {
        int[] results = new int[items.length];
        for (int i = 0; i < items.length; ++i) {
            Object value = items[i];
            if (value == null) {
                throw new NullPointerException();
            }
            results[i] = IntegerConvertor.INSTANCE.convert(value);
        }
        return results;
    }

    private long[] convertToLongArray(Object[] items) {
        long[] results = new long[items.length];
        for (int i = 0; i < items.length; ++i) {
            Object value = items[i];
            if (value == null) {
                throw new NullPointerException();
            }
            results[i] = LongConvertor.INSTANCE.convert(value);
        }
        return results;
    }

    private byte[] convertToByteArray(Object[] items) {
        byte[] results = new byte[items.length];
        for (int i = 0; i < items.length; ++i) {
            Object value = items[i];
            if (value == null) {
                throw new NullPointerException();
            }
            results[i] = ByteConvertor.INSTANCE.convert(value);
        }
        return results;
    }

    private short[] convertToShortArray(Object[] items) {
        short[] results = new short[items.length];
        for (int i = 0; i < items.length; ++i) {
            Object value = items[i];
            if (value == null) {
                throw new NullPointerException();
            }
            results[i] = ShortConvertor.INSTANCE.convert(value);
        }
        return results;
    }

    private float[] convertToFloatArray(Object[] items) {
        float[] results = new float[items.length];
        for (int i = 0; i < items.length; ++i) {
            Object value = items[i];
            if (value == null) {
                throw new NullPointerException();
            }
            results[i] = FloatConvertor.INSTANCE.convert(value).floatValue();
        }
        return results;
    }

    private double[] convertToDoubleArray(Object[] items) {
        double[] results = new double[items.length];
        for (int i = 0; i < items.length; ++i) {
            Object value = items[i];
            if (value == null) {
                throw new NullPointerException();
            }
            results[i] = DoubleConvertor.INSTANCE.convert(value);
        }
        return results;
    }

    private boolean[] convertToBooleanArray(Object[] items) {
        boolean[] results = new boolean[items.length];
        for (int i = 0; i < items.length; ++i) {
            Object value = items[i];
            if (value == null) {
                throw new NullPointerException();
            }
            results[i] = BooleanConvertor.INSTANCE.convert(value);
        }
        return results;
    }

    private char[] convertToCharArray(Object[] items) {
        char[] results = new char[items.length];
        for (int i = 0; i < items.length; ++i) {
            Object value = items[i];
            if (value == null) {
                throw new NullPointerException();
            }
            results[i] = CharacterConvertor.INSTANCE.convert(value).charValue();
        }
        return results;
    }
}

