/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class ToStringBuilder {
    private final StringBuilder sb = new StringBuilder(32);
    private final Object object;
    private final boolean formatted;

    public static String reflection(Object object) {
        return ToStringBuilder.reflection(object, true);
    }

    public static String reflection(Object object, boolean formatted) {
        ToStringBuilder builder = new ToStringBuilder(object, formatted);
        AccessibleObject[] fields = object.getClass().getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            String fieldName = ((Field)field).getName();
            if (((Field)field).getName().indexOf(36) != -1 || Modifier.isTransient(((Field)field).getModifiers()) || Modifier.isStatic(((Field)field).getModifiers())) continue;
            try {
                Object fieldValue = ((Field)field).get(object);
                builder.append(fieldName, fieldValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return builder.toString();
    }

    public ToStringBuilder(Object object) {
        this(object, true);
    }

    public ToStringBuilder(Object object, boolean formatted) {
        this.object = object;
        this.formatted = formatted;
    }

    public void append(String fieldName, Object value) {
        if (value == null) {
            value = "<null>";
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            StringBuilder str = new StringBuilder(32);
            str.append('[');
            for (int i = 0; i < length; ++i) {
                if (i >= 10) {
                    str.append(",...");
                    break;
                }
                if (i > 0) {
                    str.append(',');
                }
                str.append(Array.get(value, i));
            }
            str.append(']');
            value = str.toString();
        }
        if (this.formatted) {
            this.sb.append("  ").append(fieldName).append(" = ").append(value).append('\n');
        } else {
            if (this.sb.length() > 0) {
                this.sb.append(';');
            }
            this.sb.append(fieldName).append('=').append(value);
        }
    }

    public String build() {
        return this.toString();
    }

    public String toString() {
        if (this.formatted) {
            return this.object.getClass().getName() + "[\n" + this.sb + ']';
        }
        return this.object.getClass().getSimpleName() + '[' + this.sb + ']';
    }
}

