/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.loader;

import java.io.File;
import jetbrick.io.resource.FileSystemResource;
import jetbrick.io.resource.Resource;
import jetbrick.template.loader.AbstractResourceLoader;
import jetbrick.util.PathUtils;

public final class FileSystemResourceLoader
extends AbstractResourceLoader {
    public FileSystemResourceLoader() {
        this.root = ".";
        this.reloadable = false;
    }

    @Override
    public Resource load(String name) {
        String path = PathUtils.concat((String)this.root, (String)name);
        File file = new File(path).getAbsoluteFile();
        if (!file.exists()) {
            return null;
        }
        FileSystemResource resource = new FileSystemResource(file);
        resource.setRelativePathName(name);
        return resource;
    }
}

