/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import jetbrick.template.Errors;

public final class ALU {
    public static final Object VOID = new Object();
    public static final int NaN = 255;
    public static final int DOUBLE = 63;
    public static final int FLOAT = 31;
    public static final int LONG = 15;
    public static final int INTEGER = 7;
    public static final int SHORT = 3;
    public static final int BYTE = 1;

    public static int getNumberType(Class<?> cls) {
        if (cls == Integer.class) {
            return 7;
        }
        if (cls == Long.class) {
            return 15;
        }
        if (cls == Double.class) {
            return 63;
        }
        if (cls == Float.class) {
            return 31;
        }
        if (cls == Short.class) {
            return 3;
        }
        if (cls == Byte.class) {
            return 1;
        }
        return 255;
    }

    public static int getNumberType(Class<?> c1, Class<?> c2) {
        return ALU.getNumberType(c1) | ALU.getNumberType(c2);
    }

    public static Object plus(Object o1, Object o2) throws IllegalStateException {
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (c1 == String.class || c2 == String.class) {
            return String.valueOf(o1).concat(String.valueOf(o2));
        }
        if (Number.class.isAssignableFrom(c1) && Number.class.isAssignableFrom(c2)) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            switch (ALU.getNumberType(c1, c2)) {
                case 1: 
                case 3: 
                case 7: {
                    return n1.intValue() + n2.intValue();
                }
                case 15: {
                    return n1.longValue() + n2.longValue();
                }
                case 31: {
                    return Float.valueOf(n1.floatValue() + n2.floatValue());
                }
                case 63: {
                    return n1.doubleValue() + n2.doubleValue();
                }
            }
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type(s): %s, %s", "+", Errors.typeName(o1), Errors.typeName(o2)));
    }

    public static Object minus(Object o1, Object o2) throws IllegalStateException {
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (Number.class.isAssignableFrom(c1) && Number.class.isAssignableFrom(c2)) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            switch (ALU.getNumberType(c1, c2)) {
                case 1: 
                case 3: 
                case 7: {
                    return n1.intValue() - n2.intValue();
                }
                case 15: {
                    return n1.longValue() - n2.longValue();
                }
                case 31: {
                    return Float.valueOf(n1.floatValue() - n2.floatValue());
                }
                case 63: {
                    return n1.doubleValue() - n2.doubleValue();
                }
            }
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type(s): %s, %s", "-", Errors.typeName(o1), Errors.typeName(o2)));
    }

    public static Object mul(Object o1, Object o2) throws IllegalStateException {
        if (o1 == null || o2 == null) {
            return null;
        }
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (Number.class.isAssignableFrom(c1) && Number.class.isAssignableFrom(c2)) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            switch (ALU.getNumberType(c1, c2)) {
                case 1: 
                case 3: 
                case 7: {
                    return n1.intValue() * n2.intValue();
                }
                case 15: {
                    return n1.longValue() * n2.longValue();
                }
                case 31: {
                    return Float.valueOf(n1.floatValue() * n2.floatValue());
                }
                case 63: {
                    return n1.doubleValue() * n2.doubleValue();
                }
            }
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type(s): %s, %s", "*", Errors.typeName(o1), Errors.typeName(o2)));
    }

    public static Object div(Object o1, Object o2) throws IllegalStateException {
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (Number.class.isAssignableFrom(c1) && Number.class.isAssignableFrom(c2)) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            switch (ALU.getNumberType(c1, c2)) {
                case 1: 
                case 3: 
                case 7: {
                    return n1.intValue() / n2.intValue();
                }
                case 15: {
                    return n1.longValue() / n2.longValue();
                }
                case 31: {
                    return Float.valueOf(n1.floatValue() / n2.floatValue());
                }
                case 63: {
                    return n1.doubleValue() / n2.doubleValue();
                }
            }
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type(s): %s, %s", "/", Errors.typeName(o1), Errors.typeName(o2)));
    }

    public static Object mod(Object o1, Object o2) throws IllegalStateException {
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (Number.class.isAssignableFrom(c1) && Number.class.isAssignableFrom(c2)) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            switch (ALU.getNumberType(c1, c2)) {
                case 1: 
                case 3: 
                case 7: {
                    return n1.intValue() % n2.intValue();
                }
                case 15: {
                    return n1.longValue() % n2.longValue();
                }
                case 31: {
                    return Float.valueOf(n1.floatValue() % n2.floatValue());
                }
                case 63: {
                    return n1.doubleValue() % n2.doubleValue();
                }
            }
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type(s): %s, %s", "%", Errors.typeName(o1), Errors.typeName(o2)));
    }

    public static Object positive(Object o) throws IllegalStateException {
        if (o instanceof Number) {
            return o;
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type: %s", "+", Errors.typeName(o)));
    }

    public static Object negative(Object o) throws IllegalStateException {
        Class<?> cls = o.getClass();
        if (Number.class.isAssignableFrom(cls)) {
            Number n = (Number)o;
            if (cls == Integer.class) {
                return -n.intValue();
            }
            if (cls == Long.class) {
                return -n.longValue();
            }
            if (cls == Double.class) {
                return -n.doubleValue();
            }
            if (cls == Float.class) {
                return Float.valueOf(-n.floatValue());
            }
            if (cls == Short.class) {
                return (int)(-n.shortValue());
            }
            if (cls == Byte.class) {
                return (int)(-n.byteValue());
            }
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type: %s", "-", Errors.typeName(o)));
    }

    public static Object bitAnd(Object o1, Object o2) throws IllegalStateException {
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (Number.class.isAssignableFrom(c1) && Number.class.isAssignableFrom(c2)) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            switch (ALU.getNumberType(c1, c2)) {
                case 1: 
                case 3: 
                case 7: {
                    return n1.intValue() & n2.intValue();
                }
                case 15: {
                    return n1.longValue() & n2.longValue();
                }
            }
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type(s): %s, %s", "&", Errors.typeName(o1), Errors.typeName(o2)));
    }

    public static Object bitOr(Object o1, Object o2) throws IllegalStateException {
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (Number.class.isAssignableFrom(c1) && Number.class.isAssignableFrom(c2)) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            switch (ALU.getNumberType(c1, c2)) {
                case 1: 
                case 3: 
                case 7: {
                    return n1.intValue() | n2.intValue();
                }
                case 15: {
                    return n1.longValue() | n2.longValue();
                }
            }
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type(s): %s, %s", "|", Errors.typeName(o1), Errors.typeName(o2)));
    }

    public static Object bitXor(Object o1, Object o2) throws IllegalStateException {
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (Number.class.isAssignableFrom(c1) && Number.class.isAssignableFrom(c2)) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            switch (ALU.getNumberType(c1, c2)) {
                case 1: 
                case 3: 
                case 7: {
                    return n1.intValue() ^ n2.intValue();
                }
                case 15: {
                    return n1.longValue() ^ n2.longValue();
                }
            }
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type(s): %s, %s", "^", Errors.typeName(o1), Errors.typeName(o2)));
    }

    public static Object bitNot(Object o) throws IllegalStateException {
        Class<?> cls = o.getClass();
        if (Number.class.isAssignableFrom(cls)) {
            Number n = (Number)o;
            if (cls == Integer.class) {
                return ~n.intValue();
            }
            if (cls == Long.class) {
                return n.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (cls == Short.class) {
                return (int)(~n.shortValue());
            }
            if (cls == Byte.class) {
                return (int)(~n.byteValue());
            }
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type: %s", "~", Errors.typeName(o)));
    }

    public static Object shl(Object o1, Object o2) throws IllegalStateException {
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (Number.class.isAssignableFrom(c1) && Number.class.isAssignableFrom(c2)) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            if (c1 == Long.class) {
                if (c2 == Long.class) {
                    return n1.longValue() << (int)n2.longValue();
                }
                if (c2 == Integer.class || c2 == Short.class || c2 == Byte.class) {
                    return n1.longValue() << n2.intValue();
                }
            } else if (c1 == Integer.class || c1 == Short.class || c1 == Byte.class) {
                if (c2 == Long.class) {
                    return n1.intValue() << (int)n2.longValue();
                }
                if (c2 == Integer.class || c2 == Short.class || c2 == Byte.class) {
                    return n1.intValue() << n2.intValue();
                }
            }
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type(s): %s, %s", "<<", Errors.typeName(o1), Errors.typeName(o2)));
    }

    public static Object shr(Object o1, Object o2) throws IllegalStateException {
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (Number.class.isAssignableFrom(c1) && Number.class.isAssignableFrom(c2)) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            if (c1 == Long.class) {
                if (c2 == Long.class) {
                    return n1.longValue() >> (int)n2.longValue();
                }
                if (c2 == Integer.class || c2 == Short.class || c2 == Byte.class) {
                    return n1.longValue() >> n2.intValue();
                }
            } else if (c1 == Integer.class || c1 == Short.class || c1 == Byte.class) {
                if (c2 == Long.class) {
                    return n1.intValue() >> (int)n2.longValue();
                }
                if (c2 == Integer.class || c2 == Short.class || c2 == Byte.class) {
                    return n1.intValue() >> n2.intValue();
                }
            }
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type(s): %s, %s", ">>", Errors.typeName(o1), Errors.typeName(o2)));
    }

    public static Object ushr(Object o1, Object o2) throws IllegalStateException {
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (Number.class.isAssignableFrom(c1) && Number.class.isAssignableFrom(c2)) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            if (c1 == Long.class) {
                if (c2 == Long.class) {
                    return n1.longValue() >>> (int)n2.longValue();
                }
                if (c2 == Integer.class || c2 == Short.class || c2 == Byte.class) {
                    return n1.longValue() >>> n2.intValue();
                }
            } else if (c1 == Integer.class || c1 == Short.class || c1 == Byte.class) {
                if (c2 == Long.class) {
                    return n1.intValue() >>> (int)n2.longValue();
                }
                if (c2 == Integer.class || c2 == Short.class || c2 == Byte.class) {
                    return n1.intValue() >>> n2.intValue();
                }
            }
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type(s): %s, %s", ">>>", Errors.typeName(o1), Errors.typeName(o2)));
    }

    public static Boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return Boolean.TRUE;
        }
        if (o1 == null || o2 == null) {
            return Boolean.FALSE;
        }
        if (o1.equals(o2)) {
            return Boolean.TRUE;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            switch (ALU.getNumberType(o1.getClass(), o2.getClass())) {
                case 1: 
                case 3: 
                case 7: {
                    return n1.intValue() == n2.intValue() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 15: {
                    return n1.longValue() == n2.longValue() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 31: {
                    return n1.floatValue() == n2.floatValue() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 63: {
                    return n1.doubleValue() == n2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
                }
            }
        }
        return Boolean.FALSE;
    }

    public static Object gt(Object o1, Object o2) throws IllegalStateException {
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (Number.class.isAssignableFrom(c1) && Number.class.isAssignableFrom(c2)) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            switch (ALU.getNumberType(c1, c2)) {
                case 1: 
                case 3: 
                case 7: {
                    return n1.intValue() > n2.intValue() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 15: {
                    return n1.longValue() > n2.longValue() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 31: {
                    return n1.floatValue() > n2.floatValue() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 63: {
                    return n1.doubleValue() > n2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
                }
            }
        }
        if (c1 == c2 && Comparable.class.isAssignableFrom(c1)) {
            return ((Comparable)o1).compareTo(o2) > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type(s): %s, %s", ">", Errors.typeName(o1), Errors.typeName(o2)));
    }

    public static Object ge(Object o1, Object o2) throws IllegalStateException {
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (Number.class.isAssignableFrom(c1) && Number.class.isAssignableFrom(c2)) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            switch (ALU.getNumberType(c1, c2)) {
                case 1: 
                case 3: 
                case 7: {
                    return n1.intValue() >= n2.intValue() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 15: {
                    return n1.longValue() >= n2.longValue() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 31: {
                    return n1.floatValue() >= n2.floatValue() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 63: {
                    return n1.doubleValue() >= n2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
                }
            }
        }
        if (c1 == c2 && Comparable.class.isAssignableFrom(c1) && c2.isAssignableFrom(c1)) {
            return ((Comparable)o1).compareTo(o2) >= 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type(s): %s, %s", ">=", Errors.typeName(o1), Errors.typeName(o2)));
    }

    public static Object lt(Object o1, Object o2) throws IllegalStateException {
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (Number.class.isAssignableFrom(c1) && Number.class.isAssignableFrom(c2)) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            switch (ALU.getNumberType(c1, c2)) {
                case 1: 
                case 3: 
                case 7: {
                    return n1.intValue() < n2.intValue() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 15: {
                    return n1.longValue() < n2.longValue() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 31: {
                    return n1.floatValue() < n2.floatValue() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 63: {
                    return n1.doubleValue() < n2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
                }
            }
        }
        if (c1 == c2 && Comparable.class.isAssignableFrom(c1)) {
            return ((Comparable)o1).compareTo(o2) <= 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type(s): %s, %s", "<", Errors.typeName(o1), Errors.typeName(o2)));
    }

    public static Object le(Object o1, Object o2) throws IllegalStateException {
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (Number.class.isAssignableFrom(c1) && Number.class.isAssignableFrom(c2)) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            switch (ALU.getNumberType(c1, c2)) {
                case 1: 
                case 3: 
                case 7: {
                    return n1.intValue() <= n2.intValue() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 15: {
                    return n1.longValue() <= n2.longValue() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 31: {
                    return n1.floatValue() <= n2.floatValue() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 63: {
                    return n1.doubleValue() <= n2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
                }
            }
        }
        if (c1 == c2 && Comparable.class.isAssignableFrom(c1)) {
            return ((Comparable)o1).compareTo(o2) <= 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        throw new IllegalStateException(Errors.format("the operator `%s` is undefined for the argument type(s): %s, %s", "<=", Errors.typeName(o1), Errors.typeName(o2)));
    }

    public static boolean isTrue(Object o) {
        if (o == null) {
            return false;
        }
        Class<?> cls = o.getClass();
        if (cls == Boolean.class) {
            return (Boolean)o;
        }
        if (o instanceof Collection) {
            return !((Collection)o).isEmpty();
        }
        if (o instanceof Map) {
            return !((Map)o).isEmpty();
        }
        if (o instanceof CharSequence) {
            return ((CharSequence)o).length() > 0;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        if (cls.isArray()) {
            return Array.getLength(o) > 0;
        }
        if (cls == Character.class) {
            return ((Character)o).charValue() != '\u0000';
        }
        if (o instanceof Enumeration) {
            return ((Enumeration)o).hasMoreElements();
        }
        if (o instanceof Iterator) {
            return ((Iterator)o).hasNext();
        }
        if (o instanceof Iterable) {
            return ((Iterable)o).iterator().hasNext();
        }
        return true;
    }
}

