/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.resolver.tag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jetbrick.bean.ExecutableUtils;
import jetbrick.bean.KlassInfo;
import jetbrick.bean.MethodInfo;
import jetbrick.template.JetAnnotations;
import jetbrick.template.resolver.SignatureUtils;
import jetbrick.template.resolver.tag.TagInvoker;
import jetbrick.template.runtime.JetTagContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TagInvokerResolver {
    private static final Logger log = LoggerFactory.getLogger(TagInvokerResolver.class);
    private final ConcurrentMap<String, TagInvoker> cache = new ConcurrentHashMap<String, TagInvoker>(64);
    private final Map<String, List<MethodInfo>> tagMap = new HashMap<String, List<MethodInfo>>(32);

    public void register(Class<?> cls) {
        KlassInfo klass = KlassInfo.create(cls);
        int i = 0;
        for (MethodInfo method : klass.getDeclaredMethods()) {
            Class[] parameterTypes;
            if (!method.isStatic() || !method.isPublic() || (parameterTypes = method.getParameterTypes()).length <= 0 || !JetTagContext.class.isAssignableFrom(parameterTypes[0])) continue;
            this.register(method);
            ++i;
        }
        log.info("import {} tags from {}", (Object)i, cls);
    }

    public void register(MethodInfo method) {
        List<MethodInfo> methods;
        String name = method.getName();
        JetAnnotations.Name rename = method.getMethod().getAnnotation(JetAnnotations.Name.class);
        if (rename != null && !"".equals(rename.value())) {
            name = rename.value();
        }
        if (log.isInfoEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(name).append('(');
            Class[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(parameterTypes[i].getName());
            }
            sb.append(')');
            log.debug("import tag: {}", (Object)sb.toString());
        }
        if ((methods = this.tagMap.get(name)) == null) {
            methods = new ArrayList<MethodInfo>(4);
            this.tagMap.put(name, methods);
        }
        methods.add(method);
    }

    public TagInvoker resolve(String name, Class<?>[] argumentTypes) {
        String signature = SignatureUtils.getFunctionSignature(name, argumentTypes);
        TagInvoker found = (TagInvoker)this.cache.get(signature);
        if (found != null) {
            return found;
        }
        TagInvoker tag = this.doGetTagInvoker(name, argumentTypes);
        if (tag != null) {
            this.cache.put(signature, tag);
            return tag;
        }
        return null;
    }

    private TagInvoker doGetTagInvoker(String name, Class<?>[] argumentTypes) {
        List<MethodInfo> tags = this.tagMap.get(name);
        if (tags != null) {
            int length = argumentTypes.length;
            Class[] types = new Class[length + 1];
            types[0] = JetTagContext.class;
            System.arraycopy(argumentTypes, 0, types, 1, length);
            MethodInfo tag = (MethodInfo)ExecutableUtils.searchExecutable(tags, null, (Class[])types);
            if (tag != null) {
                return new TagInvoker(tag);
            }
        }
        return null;
    }
}

