/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.ignite;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.grid.CommandResult;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.GridCommand;
import io.github.bucket4j.grid.GridProxy;
import io.github.bucket4j.grid.jcache.JCacheEntryProcessor;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;

public class IgniteProxy<K extends Serializable>
implements GridProxy<K> {
    private final IgniteCache<K, GridBucketState> cache;

    public IgniteProxy(IgniteCache<K, GridBucketState> cache) {
        this.cache = cache;
    }

    public <T extends Serializable> CommandResult<T> execute(K key, GridCommand<T> command) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.executeProcessor(command);
        return (CommandResult)this.cache.invoke(key, (EntryProcessor)entryProcessor, new Object[0]);
    }

    public void createInitialState(K key, BucketConfiguration configuration) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.initStateProcessor((BucketConfiguration)configuration);
        this.cache.invoke(key, (EntryProcessor)entryProcessor, new Object[0]);
    }

    public <T extends Serializable> T createInitialStateAndExecute(K key, BucketConfiguration configuration, GridCommand<T> command) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.initStateAndExecuteProcessor(command, (BucketConfiguration)configuration);
        CommandResult result = (CommandResult)this.cache.invoke(key, (EntryProcessor)entryProcessor, new Object[0]);
        return (T)result.getData();
    }

    public <T extends Serializable> CompletableFuture<CommandResult<T>> executeAsync(K key, GridCommand<T> command) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.executeProcessor(command);
        return this.invokeAsync(key, entryProcessor);
    }

    public <T extends Serializable> CompletableFuture<T> createInitialStateAndExecuteAsync(K key, BucketConfiguration configuration, GridCommand<T> command) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.initStateAndExecuteProcessor(command, (BucketConfiguration)configuration);
        CompletableFuture<CommandResult<T>> result = this.invokeAsync(key, entryProcessor);
        return result.thenApply(f -> f.getData());
    }

    public Optional<BucketConfiguration> getConfiguration(K key) {
        GridBucketState state = (GridBucketState)this.cache.get(key);
        if (state == null) {
            return Optional.empty();
        }
        return Optional.of(state.getConfiguration());
    }

    public boolean isAsyncModeSupported() {
        return true;
    }

    private <T extends Serializable> CompletableFuture<CommandResult<T>> invokeAsync(K key, JCacheEntryProcessor<K, T> entryProcessor) {
        return IgniteProxy.convertFuture(this.cache.invokeAsync(key, entryProcessor, new Object[0]));
    }

    private static <T> CompletableFuture<T> convertFuture(IgniteFuture<T> igniteFuture) {
        CompletableFuture completableFuture = new CompletableFuture();
        igniteFuture.listen((IgniteInClosure & Serializable)completedIgniteFuture -> {
            try {
                completableFuture.complete(completedIgniteFuture.get());
            }
            catch (Throwable t) {
                completableFuture.completeExceptionally(t);
            }
        });
        return completableFuture;
    }
}

