/*
 * Decompiled with CFR 0.152.
 */
package com.zen.elasticjob.spring.boot;

import com.dangdang.ddframe.job.api.ElasticJob;
import com.dangdang.ddframe.job.api.JobType;
import com.dangdang.ddframe.job.api.dataflow.DataflowJob;
import com.dangdang.ddframe.job.api.script.ScriptJob;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import com.dangdang.ddframe.job.config.JobCoreConfiguration;
import com.dangdang.ddframe.job.config.JobTypeConfiguration;
import com.dangdang.ddframe.job.config.dataflow.DataflowJobConfiguration;
import com.dangdang.ddframe.job.config.script.ScriptJobConfiguration;
import com.dangdang.ddframe.job.config.simple.SimpleJobConfiguration;
import com.dangdang.ddframe.job.event.JobEventConfiguration;
import com.dangdang.ddframe.job.event.rdb.JobEventRdbConfiguration;
import com.dangdang.ddframe.job.executor.handler.JobProperties;
import com.dangdang.ddframe.job.lite.api.listener.AbstractDistributeOnceElasticJobListener;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.spring.api.SpringJobScheduler;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperRegistryCenter;
import com.zen.elasticjob.spring.boot.RegistryCenterAutoConfiguration;
import com.zen.elasticjob.spring.boot.annotation.ElasticJobConfig;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
@ConditionalOnClass(value={ElasticJob.class})
@ConditionalOnBean(annotation={ElasticJobConfig.class})
@AutoConfigureAfter(value={RegistryCenterAutoConfiguration.class})
public class ElasticJobAutoConfiguration {
    @Resource
    private ZookeeperRegistryCenter regCenter;
    @Autowired
    private ApplicationContext applicationContext;

    @PostConstruct
    public void init() {
        Map elasticJobMap = this.applicationContext.getBeansOfType(ElasticJob.class);
        for (ElasticJob elasticJob : elasticJobMap.values()) {
            Class<?> jobClass = elasticJob.getClass();
            ElasticJobConfig elasticJobConfig = jobClass.getAnnotation(ElasticJobConfig.class);
            JobType jobType = this.getJobType(elasticJob);
            if (Objects.equals(JobType.SCRIPT, jobType)) {
                elasticJob = null;
            }
            LiteJobConfiguration liteJobConfiguration = this.getLiteJobConfiguration(jobType, jobClass, elasticJobConfig);
            JobEventRdbConfiguration jobEventRdbConfiguration = this.getJobEventRdbConfiguration(elasticJobConfig.eventTraceRdbDataSource());
            ElasticJobListener[] elasticJobListeners = this.creatElasticJobListeners(elasticJobConfig);
            ElasticJobListener[] elasticJobListenerArray = elasticJobListeners = null == elasticJobListeners ? new ElasticJobListener[]{} : elasticJobListeners;
            if (null == jobEventRdbConfiguration) {
                new SpringJobScheduler(elasticJob, (CoordinatorRegistryCenter)this.regCenter, liteJobConfiguration, elasticJobListeners).init();
                continue;
            }
            new SpringJobScheduler(elasticJob, (CoordinatorRegistryCenter)this.regCenter, liteJobConfiguration, (JobEventConfiguration)jobEventRdbConfiguration, elasticJobListeners).init();
        }
    }

    private JobEventRdbConfiguration getJobEventRdbConfiguration(String eventTraceRdbDataSource) {
        if (StringUtils.isBlank((CharSequence)eventTraceRdbDataSource)) {
            return null;
        }
        if (!this.applicationContext.containsBean(eventTraceRdbDataSource)) {
            throw new RuntimeException("not exist datasource [" + eventTraceRdbDataSource + "] !");
        }
        DataSource dataSource = (DataSource)this.applicationContext.getBean(eventTraceRdbDataSource);
        return new JobEventRdbConfiguration(dataSource);
    }

    private JobType getJobType(ElasticJob elasticJob) {
        if (elasticJob instanceof SimpleJob) {
            return JobType.SIMPLE;
        }
        if (elasticJob instanceof DataflowJob) {
            return JobType.DATAFLOW;
        }
        if (elasticJob instanceof ScriptJob) {
            return JobType.SCRIPT;
        }
        throw new RuntimeException("unknown JobType [" + elasticJob.getClass() + "]!");
    }

    private JobCoreConfiguration getJobCoreConfiguration(String jobName, ElasticJobConfig elasticJobConfig) {
        JobCoreConfiguration.Builder builder = JobCoreConfiguration.newBuilder((String)jobName, (String)elasticJobConfig.cron(), (int)elasticJobConfig.shardingTotalCount()).shardingItemParameters(elasticJobConfig.shardingItemParameters()).jobParameter(elasticJobConfig.jobParameter()).failover(elasticJobConfig.failover()).misfire(elasticJobConfig.misfire()).description(elasticJobConfig.description());
        if (StringUtils.isNotBlank((CharSequence)elasticJobConfig.jobExceptionHandler())) {
            builder.jobProperties(JobProperties.JobPropertiesEnum.JOB_EXCEPTION_HANDLER.getKey(), elasticJobConfig.jobExceptionHandler());
        }
        if (StringUtils.isNotBlank((CharSequence)elasticJobConfig.executorServiceHandler())) {
            builder.jobProperties(JobProperties.JobPropertiesEnum.EXECUTOR_SERVICE_HANDLER.getKey(), elasticJobConfig.executorServiceHandler());
        }
        return builder.build();
    }

    private LiteJobConfiguration getLiteJobConfiguration(JobType jobType, Class<? extends ElasticJob> jobClass, ElasticJobConfig elasticJobConfig) {
        JobCoreConfiguration jobCoreConfiguration = this.getJobCoreConfiguration(jobClass.getName(), elasticJobConfig);
        JobTypeConfiguration jobTypeConfiguration = this.getJobTypeConfiguration(jobCoreConfiguration, jobType, jobClass.getCanonicalName(), elasticJobConfig.streamingProcess(), elasticJobConfig.scriptCommandLine());
        return LiteJobConfiguration.newBuilder((JobTypeConfiguration)Objects.requireNonNull(jobTypeConfiguration)).monitorExecution(elasticJobConfig.monitorExecution()).monitorPort(elasticJobConfig.monitorPort()).maxTimeDiffSeconds(elasticJobConfig.maxTimeDiffSeconds()).jobShardingStrategyClass(elasticJobConfig.jobShardingStrategyClass()).reconcileIntervalMinutes(elasticJobConfig.reconcileIntervalMinutes()).disabled(elasticJobConfig.disabled()).overwrite(elasticJobConfig.overwrite()).build();
    }

    private JobTypeConfiguration getJobTypeConfiguration(JobCoreConfiguration jobCoreConfiguration, JobType jobType, String jobClass, boolean streamingProcess, String scriptCommandLine) {
        switch (jobType) {
            case DATAFLOW: {
                return new DataflowJobConfiguration(jobCoreConfiguration, jobClass, streamingProcess);
            }
            case SCRIPT: {
                return new ScriptJobConfiguration(jobCoreConfiguration, scriptCommandLine);
            }
        }
        return new SimpleJobConfiguration(jobCoreConfiguration, jobClass);
    }

    private ElasticJobListener[] creatElasticJobListeners(ElasticJobConfig elasticJobConfig) {
        AbstractDistributeOnceElasticJobListener distributedListener;
        ArrayList<Object> elasticJobListeners = new ArrayList<Object>(2);
        ElasticJobListener elasticJobListener = this.creatElasticJobListener(elasticJobConfig.listener());
        if (null != elasticJobListener) {
            elasticJobListeners.add(elasticJobListener);
        }
        if (null != (distributedListener = this.creatAbstractDistributeOnceElasticJobListener(elasticJobConfig.distributedListener(), elasticJobConfig.startedTimeoutMilliseconds(), elasticJobConfig.completedTimeoutMilliseconds()))) {
            elasticJobListeners.add(distributedListener);
        }
        if (CollectionUtils.isEmpty(elasticJobListeners)) {
            return null;
        }
        ElasticJobListener[] elasticJobListenerArray = new ElasticJobListener[elasticJobListeners.size()];
        for (int i = 0; i < elasticJobListeners.size(); ++i) {
            elasticJobListenerArray[i] = (ElasticJobListener)elasticJobListeners.get(i);
        }
        return elasticJobListenerArray;
    }

    private ElasticJobListener creatElasticJobListener(Class<? extends ElasticJobListener> listener) {
        if (listener.isInterface()) {
            return null;
        }
        if (this.applicationContext.containsBean(listener.getSimpleName())) {
            return (ElasticJobListener)this.applicationContext.getBean(listener.getSimpleName(), ElasticJobListener.class);
        }
        return this.registerElasticJobListener(listener);
    }

    private AbstractDistributeOnceElasticJobListener creatAbstractDistributeOnceElasticJobListener(Class<? extends AbstractDistributeOnceElasticJobListener> distributedListener, long startedTimeoutMilliseconds, long completedTimeoutMilliseconds) {
        if (Objects.equals(distributedListener, AbstractDistributeOnceElasticJobListener.class)) {
            return null;
        }
        if (this.applicationContext.containsBean(distributedListener.getSimpleName())) {
            return (AbstractDistributeOnceElasticJobListener)this.applicationContext.getBean(distributedListener.getSimpleName(), AbstractDistributeOnceElasticJobListener.class);
        }
        return this.registerAbstractDistributeOnceElasticJobListener(distributedListener, startedTimeoutMilliseconds, completedTimeoutMilliseconds);
    }

    private ElasticJobListener registerElasticJobListener(Class<? extends ElasticJobListener> listener) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(listener);
        beanDefinitionBuilder.setScope("prototype");
        this.getDefaultListableBeanFactory().registerBeanDefinition(listener.getSimpleName(), (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        return (ElasticJobListener)this.applicationContext.getBean(listener.getSimpleName(), listener);
    }

    private AbstractDistributeOnceElasticJobListener registerAbstractDistributeOnceElasticJobListener(Class<? extends AbstractDistributeOnceElasticJobListener> distributedListener, long startedTimeoutMilliseconds, long completedTimeoutMilliseconds) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(distributedListener);
        beanDefinitionBuilder.setScope("prototype");
        beanDefinitionBuilder.addConstructorArgValue((Object)startedTimeoutMilliseconds);
        beanDefinitionBuilder.addConstructorArgValue((Object)completedTimeoutMilliseconds);
        this.getDefaultListableBeanFactory().registerBeanDefinition(distributedListener.getSimpleName(), (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        return (AbstractDistributeOnceElasticJobListener)this.applicationContext.getBean(distributedListener.getSimpleName(), distributedListener);
    }

    private DefaultListableBeanFactory getDefaultListableBeanFactory() {
        return (DefaultListableBeanFactory)((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
    }
}

