/*
 * Decompiled with CFR 0.152.
 */
package com.zen.elasticjob.spring.boot;

import com.dangdang.ddframe.job.api.ElasticJob;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperConfiguration;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperRegistryCenter;
import com.zen.elasticjob.spring.boot.ZookeeperRegistryProperties;
import com.zen.elasticjob.spring.boot.annotation.ElasticJobConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ElasticJob.class})
@ConditionalOnBean(annotation={ElasticJobConfig.class})
@EnableConfigurationProperties(value={ZookeeperRegistryProperties.class})
public class RegistryCenterAutoConfiguration {
    @Autowired
    private ZookeeperRegistryProperties regCenterProperties;

    @Bean(initMethod="init")
    @ConditionalOnMissingBean
    public ZookeeperRegistryCenter regCenter() {
        ZookeeperConfiguration zookeeperConfiguration = new ZookeeperConfiguration(this.regCenterProperties.getServerLists(), this.regCenterProperties.getNamespace());
        zookeeperConfiguration.setBaseSleepTimeMilliseconds(this.regCenterProperties.getBaseSleepTimeMilliseconds());
        zookeeperConfiguration.setConnectionTimeoutMilliseconds(this.regCenterProperties.getConnectionTimeoutMilliseconds());
        zookeeperConfiguration.setMaxSleepTimeMilliseconds(this.regCenterProperties.getMaxSleepTimeMilliseconds());
        zookeeperConfiguration.setSessionTimeoutMilliseconds(this.regCenterProperties.getSessionTimeoutMilliseconds());
        zookeeperConfiguration.setMaxRetries(this.regCenterProperties.getMaxRetries());
        zookeeperConfiguration.setDigest(this.regCenterProperties.getDigest());
        return new ZookeeperRegistryCenter(zookeeperConfiguration);
    }
}

