/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.collection.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import java.io.Serializable;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbstractSynchronizedIntCollection
implements MutableIntCollection,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    @GuardedBy(value="this.lock")
    private final MutableIntCollection collection;

    protected AbstractSynchronizedIntCollection(MutableIntCollection collection) {
        this(collection, null);
    }

    protected AbstractSynchronizedIntCollection(MutableIntCollection collection, Object newLock) {
        this.collection = collection;
        this.lock = newLock == null ? this : newLock;
    }

    protected Object getLock() {
        return this.lock;
    }

    protected MutableIntCollection getIntCollection() {
        return this.collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.collection.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntCollection select(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntCollection reject(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntCollection with(int element) {
        Object object = this.lock;
        synchronized (object) {
            this.add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntCollection without(int element) {
        Object object = this.lock;
        synchronized (object) {
            this.remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntCollection withAll(IntIterable elements) {
        Object object = this.lock;
        synchronized (object) {
            this.addAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntCollection withoutAll(IntIterable elements) {
        Object object = this.lock;
        synchronized (object) {
            this.removeAll(elements);
        }
        return this;
    }

    public MutableIntCollection asUnmodifiable() {
        return new UnmodifiableIntCollection(this);
    }

    public MutableIntCollection asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableIntCollection toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toImmutable();
        }
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(int value) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(int ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(IntIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(int newItem) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.add(newItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.addAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(IntIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.addAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(int value) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.remove(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(IntIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.removeAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(int ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.removeAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(IntIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.retainAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(int ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.retainAll(source);
        }
    }

    public IntIterator intIterator() {
        return this.collection.intIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(IntProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anySatisfy(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allSatisfy(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noneSatisfy(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sum() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int max() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int min() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int minIfEmpty(int defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.minIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int maxIfEmpty(int defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.maxIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double average() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.average();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double median() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.median();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntList toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] toSortedArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toSortedArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.collection.injectInto(injectedValue, function);
        }
    }
}

