/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.factory.list.primitive.ImmutableIntListFactory;
import com.gs.collections.api.list.primitive.ImmutableIntList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableIntArrayList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableIntEmptyList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableIntSingletonList;

public class ImmutableIntListFactoryImpl
implements ImmutableIntListFactory {
    public ImmutableIntList of() {
        return this.with();
    }

    public ImmutableIntList with() {
        return ImmutableIntEmptyList.INSTANCE;
    }

    public ImmutableIntList of(int one) {
        return this.with(one);
    }

    public ImmutableIntList with(int one) {
        return new ImmutableIntSingletonList(one);
    }

    public ImmutableIntList of(int ... items) {
        return this.with(items);
    }

    public ImmutableIntList with(int ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableIntArrayList.newListWith(items);
    }

    public ImmutableIntList ofAll(IntIterable items) {
        return this.withAll(items);
    }

    public ImmutableIntList withAll(IntIterable items) {
        if (items instanceof ImmutableIntList) {
            return (ImmutableIntList)items;
        }
        return this.with(items.toArray());
    }
}

