/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.strategy.mutable;

import com.gs.collections.api.block.HashingStrategy;
import com.gs.collections.api.factory.set.strategy.MutableHashingStrategySetFactory;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.impl.set.strategy.mutable.UnifiedSetWithHashingStrategy;
import com.gs.collections.impl.utility.Iterate;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class MutableHashingStrategySetFactoryImpl
implements MutableHashingStrategySetFactory {
    public <T> MutableSet<T> of(HashingStrategy<? super T> hashingStrategy) {
        return this.with(hashingStrategy);
    }

    public <T> MutableSet<T> with(HashingStrategy<? super T> hashingStrategy) {
        return UnifiedSetWithHashingStrategy.newSetWith(hashingStrategy, new Object[0]);
    }

    public <T> MutableSet<T> of(HashingStrategy<? super T> hashingStrategy, T ... items) {
        return this.with(hashingStrategy, items);
    }

    public <T> MutableSet<T> with(HashingStrategy<? super T> hashingStrategy, T ... items) {
        return UnifiedSetWithHashingStrategy.newSetWith(hashingStrategy, items);
    }

    public <T> MutableSet<T> ofAll(HashingStrategy<? super T> hashingStrategy, Iterable<? extends T> items) {
        return this.withAll(hashingStrategy, items);
    }

    public <T> MutableSet<T> withAll(HashingStrategy<? super T> hashingStrategy, Iterable<? extends T> items) {
        if (Iterate.isEmpty(items)) {
            return this.with(hashingStrategy);
        }
        return UnifiedSetWithHashingStrategy.newSet(hashingStrategy, items);
    }
}

