/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Nullable;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Join {
    private Join() {
    }

    public static <T extends Appendable> T join(T appendable, String delimiter, Iterator<?> tokens) {
        Preconditions.checkNotNull(appendable);
        Preconditions.checkNotNull(delimiter);
        Preconditions.checkNotNull(tokens);
        if (tokens.hasNext()) {
            try {
                Join.appendOneToken(appendable, tokens.next());
                while (tokens.hasNext()) {
                    appendable.append(delimiter);
                    Join.appendOneToken(appendable, tokens.next());
                }
            }
            catch (IOException e) {
                throw new JoinException(e);
            }
        }
        return appendable;
    }

    public static String join(String delimiter, Iterable<?> tokens) {
        Preconditions.checkNotNull(tokens);
        return Join.join(delimiter, tokens.iterator());
    }

    public static <T extends Appendable> T join(T appendable, String delimiter, Iterable<?> tokens) {
        Preconditions.checkNotNull(tokens);
        return Join.join(appendable, delimiter, tokens.iterator());
    }

    public static <T extends Appendable> T join(T appendable, String delimiter, Object[] tokens) {
        Preconditions.checkNotNull(tokens);
        return Join.join(appendable, delimiter, Arrays.asList(tokens));
    }

    public static <T extends Appendable> T join(T appendable, String delimiter, @Nullable Object firstToken, Object ... otherTokens) {
        Preconditions.checkNotNull(otherTokens);
        return Join.join(appendable, delimiter, Join.asList(firstToken, otherTokens));
    }

    public static String join(String delimiter, Iterator<?> tokens) {
        StringBuilder sb = new StringBuilder();
        Join.join(sb, delimiter, tokens);
        return sb.toString();
    }

    public static String join(String delimiter, Object[] tokens) {
        Preconditions.checkNotNull(tokens);
        return Join.join(delimiter, Arrays.asList(tokens));
    }

    public static String join(String delimiter, @Nullable Object firstToken, Object ... otherTokens) {
        Preconditions.checkNotNull(otherTokens);
        return Join.join(delimiter, Join.asList(firstToken, otherTokens));
    }

    private static void appendOneToken(Appendable appendable, Object token) throws IOException {
        appendable.append(Join.toCharSequence(token));
    }

    private static CharSequence toCharSequence(Object token) {
        return token instanceof CharSequence ? (CharSequence)token : String.valueOf(token);
    }

    private static List<Object> asList(final Object first, final Object[] rest) {
        return new AbstractList<Object>(){

            @Override
            public int size() {
                return rest.length + 1;
            }

            @Override
            public Object get(int index) {
                return index == 0 ? first : rest[index - 1];
            }
        };
    }

    public static class JoinException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private JoinException(IOException cause) {
            super(cause);
        }
    }
}

