/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.genericdao.dao.hibernate;

import com.googlecode.genericdao.dao.hibernate.GeneralDAO;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.SearchResult;
import com.googlecode.genericdao.search.flex.FlexSearch;
import com.googlecode.genericdao.search.flex.FlexSearchWrapper;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexDAOAdapter {
    private GeneralDAO dao;

    public void setDao(GeneralDAO dao) {
        this.dao = dao;
    }

    public Object find(String className, Serializable id) throws ClassNotFoundException {
        Class<?> type = Class.forName(className);
        return this.dao.find(type, id);
    }

    public Object[] findMulti(String className, Serializable[] ids) throws ClassNotFoundException {
        Class<?> type = Class.forName(className);
        return this.dao.find(type, ids);
    }

    public List<?> findAll(String className) throws ClassNotFoundException {
        Class<?> type = Class.forName(className);
        return this.dao.findAll(type);
    }

    public Object save(Object entity) {
        this.dao.save(entity);
        return entity;
    }

    public Object[] saveMulti(Object[] entities) {
        this.dao.save(entities);
        return entities;
    }

    public void remove(Object entity) {
        this.dao.remove(entity);
    }

    public void removeById(String className, Serializable id) throws ClassNotFoundException {
        Class<?> type = Class.forName(className);
        this.dao.removeById(type, id);
    }

    public void removeMulti(Object[] entities) {
        this.dao.remove(entities);
    }

    public void removeMultiById(String className, Serializable[] ids) throws ClassNotFoundException {
        Class<?> type = Class.forName(className);
        this.dao.removeByIds(type, ids);
    }

    public List<?> search(FlexSearch flexSearch) throws ClassNotFoundException {
        return this.dao.search((ISearch)new FlexSearchWrapper(flexSearch));
    }

    public int count(FlexSearch flexSearch) throws ClassNotFoundException {
        return this.dao.count((ISearch)new FlexSearchWrapper(flexSearch));
    }

    public SearchResult<?> searchAndCount(FlexSearch flexSearch) throws ClassNotFoundException {
        return this.dao.searchAndCount((ISearch)new FlexSearchWrapper(flexSearch));
    }

    public Object searchUnique(FlexSearch flexSearch) throws ClassNotFoundException {
        return this.dao.searchUnique((ISearch)new FlexSearchWrapper(flexSearch));
    }
}

