/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.util.Iterator;
import org.h2.mvstore.DataUtils;

public class ConcurrentLinkedList<K> {
    static final Entry<?> NULL = new Entry<Object>(null, null);
    volatile Entry<K> head = NULL;

    public K peekFirst() {
        Entry<K> entry = this.head;
        return entry.obj;
    }

    public K peekLast() {
        Entry<K> entry = this.head;
        while (entry != NULL && entry.next != NULL) {
            entry = entry.next;
        }
        return entry.obj;
    }

    public synchronized void add(K k) {
        this.head = Entry.append(this.head, k);
    }

    public synchronized boolean removeFirst(K k) {
        if (this.head.obj != k) {
            return false;
        }
        this.head = this.head.next;
        return true;
    }

    public synchronized boolean removeLast(K k) {
        if (this.peekLast() != k) {
            return false;
        }
        this.head = Entry.removeLast(this.head);
        return true;
    }

    public Iterator<K> iterator() {
        return new Iterator<K>(){
            Entry<K> current;
            {
                this.current = ConcurrentLinkedList.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.current != NULL;
            }

            @Override
            public K next() {
                Object k = this.current.obj;
                this.current = this.current.next;
                return k;
            }

            @Override
            public void remove() {
                throw DataUtils.newUnsupportedOperationException("remove");
            }
        };
    }

    private static class Entry<K> {
        final K obj;
        Entry<K> next;

        Entry(K k, Entry<K> entry) {
            this.obj = k;
            this.next = entry;
        }

        static <K> Entry<K> append(Entry<K> entry, K k) {
            if (entry == NULL) {
                return new Entry<K>(k, NULL);
            }
            return new Entry<K>(entry.obj, Entry.append(entry.next, k));
        }

        static <K> Entry<K> removeLast(Entry<K> entry) {
            if (entry == NULL || entry.next == NULL) {
                return NULL;
            }
            return new Entry<K>(entry.obj, Entry.removeLast(entry.next));
        }
    }
}

