/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.cache;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.cache.IMutableCache;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.SoftHashMap;
import com.helger.commons.collection.impl.SoftLinkedHashMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import com.helger.commons.statistics.IMutableStatisticsHandlerCache;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.ToStringGenerator;
import java.util.Map;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractCache<KEYTYPE, VALUETYPE>
implements IMutableCache<KEYTYPE, VALUETYPE> {
    public static final String STATISTICS_PREFIX = "cache:";
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractCache.class);
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final int m_nMaxSize;
    private final String m_sCacheName;
    protected final IMutableStatisticsHandlerCache m_aCacheAccessStats;
    private final IMutableStatisticsHandlerCounter m_aCacheRemoveStats;
    private final IMutableStatisticsHandlerCounter m_aCacheClearStats;
    @CodingStyleguideUnaware
    private Map<KEYTYPE, VALUETYPE> m_aCache;

    public AbstractCache(@Nonnull String string) {
        this(-1, string);
    }

    public AbstractCache(@CheckForSigned int n, @Nonnull @Nonempty String string) {
        this.m_nMaxSize = n;
        this.m_sCacheName = ValueEnforcer.notEmpty(string, "cacheName");
        this.m_aCacheAccessStats = StatisticsManager.getCacheHandler(STATISTICS_PREFIX + string + "$access");
        this.m_aCacheRemoveStats = StatisticsManager.getCounterHandler(STATISTICS_PREFIX + string + "$remove");
        this.m_aCacheClearStats = StatisticsManager.getCounterHandler(STATISTICS_PREFIX + string + "$clear");
    }

    public final int getMaxSize() {
        return this.m_nMaxSize;
    }

    public final boolean hasMaxSize() {
        return this.m_nMaxSize > 0;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sCacheName;
    }

    @Nonnull
    @ReturnsMutableCopy
    @OverrideOnDemand
    @CodingStyleguideUnaware
    protected Map<KEYTYPE, VALUETYPE> createCache() {
        return this.hasMaxSize() ? new SoftLinkedHashMap(this.m_nMaxSize) : new SoftHashMap();
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected final void putInCacheNotLocked(@Nonnull KEYTYPE KEYTYPE, @Nonnull VALUETYPE VALUETYPE) {
        ValueEnforcer.notNull(KEYTYPE, "cacheKey");
        ValueEnforcer.notNull(VALUETYPE, "cacheValue");
        if (this.m_aCache == null) {
            this.m_aCache = this.createCache();
            if (this.m_aCache == null) {
                throw new IllegalStateException("No cache created!");
            }
        }
        this.m_aCache.put(KEYTYPE, VALUETYPE);
    }

    protected final void putInCache(@Nonnull KEYTYPE KEYTYPE, @Nonnull VALUETYPE VALUETYPE) {
        ValueEnforcer.notNull(KEYTYPE, "cacheKey");
        ValueEnforcer.notNull(VALUETYPE, "cacheValue");
        this.m_aRWLock.writeLocked(() -> this.putInCacheNotLocked(KEYTYPE, VALUETYPE));
    }

    @Nullable
    @MustBeLocked(value=ELockType.READ)
    protected final VALUETYPE getFromCacheNoStatsNotLocked(@Nullable KEYTYPE KEYTYPE) {
        return this.m_aCache == null ? null : (VALUETYPE)this.m_aCache.get(KEYTYPE);
    }

    @Nullable
    @OverridingMethodsMustInvokeSuper
    protected final VALUETYPE getFromCacheNoStats(@Nullable KEYTYPE KEYTYPE) {
        return (VALUETYPE)this.m_aRWLock.readLocked(() -> this.getFromCacheNoStatsNotLocked(KEYTYPE));
    }

    private void _updateStats(boolean bl) {
        if (bl) {
            this.m_aCacheAccessStats.cacheMiss();
        } else {
            this.m_aCacheAccessStats.cacheHit();
        }
    }

    @Nullable
    protected final VALUETYPE getFromCacheNotLocked(@Nullable KEYTYPE KEYTYPE) {
        VALUETYPE VALUETYPE = this.getFromCacheNoStatsNotLocked(KEYTYPE);
        this._updateStats(VALUETYPE == null);
        return VALUETYPE;
    }

    @Override
    @Nullable
    @OverridingMethodsMustInvokeSuper
    public VALUETYPE getFromCache(KEYTYPE KEYTYPE) {
        VALUETYPE VALUETYPE = this.getFromCacheNoStats(KEYTYPE);
        this._updateStats(VALUETYPE == null);
        return VALUETYPE;
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public EChange removeFromCache(KEYTYPE KEYTYPE) {
        return this.m_aRWLock.writeLocked(() -> {
            if (this.m_aCache == null || this.m_aCache.remove(KEYTYPE) == null) {
                return EChange.UNCHANGED;
            }
            this.m_aCacheRemoveStats.increment();
            return EChange.CHANGED;
        });
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public EChange clearCache() {
        return this.m_aRWLock.writeLocked(() -> {
            if (this.m_aCache == null || this.m_aCache.isEmpty()) {
                return EChange.UNCHANGED;
            }
            this.m_aCache.clear();
            this.m_aCacheClearStats.increment();
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Cache was cleared: " + this.getClass().getName());
            }
            return EChange.CHANGED;
        });
    }

    @Override
    @Nonnegative
    public int getSize() {
        return this.m_aRWLock.readLocked(() -> CollectionHelper.getSize(this.m_aCache));
    }

    @Override
    public boolean isEmpty() {
        return this.m_aRWLock.readLocked(() -> CollectionHelper.isEmpty(this.m_aCache));
    }

    @Override
    public boolean isNotEmpty() {
        return this.m_aRWLock.readLocked(() -> CollectionHelper.isNotEmpty(this.m_aCache));
    }

    public String toString() {
        return new ToStringGenerator(this).append("cacheName", this.m_sCacheName).append("content", this.m_aCache).toString();
    }
}

