/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.codec.DecodeException;
import com.helger.commons.codec.EncodeException;
import com.helger.commons.codec.IByteArrayCodec;
import com.helger.commons.string.StringHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.BitSet;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class URLCodec
implements IByteArrayCodec {
    private static final byte ESCAPE_CHAR = 37;
    private static final byte SPACE = 32;
    private static final byte PLUS = 43;
    private static final BitSet PRINTABLE_CHARS;
    private final BitSet m_aPrintableChars;

    @Nonnull
    @ReturnsMutableCopy
    public static BitSet getDefaultPrintableChars() {
        return (BitSet)PRINTABLE_CHARS.clone();
    }

    public URLCodec() {
        this(PRINTABLE_CHARS);
    }

    public URLCodec(@Nonnull BitSet bitSet) {
        this.m_aPrintableChars = (BitSet)bitSet.clone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public BitSet getPrintableChars() {
        return (BitSet)this.m_aPrintableChars.clone();
    }

    public static final void writeEncodedURLByte(int n, @Nonnull OutputStream outputStream) throws IOException {
        char c = StringHelper.getHexCharUpperCase(n >> 4 & 0xF);
        char c2 = StringHelper.getHexCharUpperCase(n & 0xF);
        outputStream.write(37);
        outputStream.write(c);
        outputStream.write(c2);
    }

    @Override
    public void encode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose OutputStream outputStream) {
        if (byArray == null || n2 == 0) {
            return;
        }
        try {
            for (int i = 0; i < n2; ++i) {
                int n3 = byArray[n + i] & 0xFF;
                if (this.m_aPrintableChars.get(n3)) {
                    if (n3 == 32) {
                        outputStream.write(43);
                        continue;
                    }
                    outputStream.write(n3);
                    continue;
                }
                URLCodec.writeEncodedURLByte(n3, outputStream);
            }
        }
        catch (IOException iOException) {
            throw new EncodeException("Failed to encode URL", iOException);
        }
    }

    @Override
    public void decode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose OutputStream outputStream) {
        if (byArray == null || n2 == 0) {
            return;
        }
        try {
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[n + i];
                if (by == 43) {
                    outputStream.write(32);
                    continue;
                }
                if (by == 37) {
                    if (i >= n2 - 2) {
                        throw new DecodeException("Invalid URL encoding. Premature end of input after escape char");
                    }
                    char c = (char)byArray[n + i + 1];
                    char c2 = (char)byArray[n + i + 2];
                    i += 2;
                    int n3 = StringHelper.getHexByte(c, c2);
                    if (n3 < 0) {
                        throw new DecodeException("Invalid URL encoding for " + c + " and " + c2);
                    }
                    outputStream.write(n3);
                    continue;
                }
                outputStream.write(by);
            }
        }
        catch (IOException iOException) {
            throw new DecodeException("Failed to decode URL", iOException);
        }
    }

    static {
        int n;
        PRINTABLE_CHARS = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        PRINTABLE_CHARS.set(45);
        PRINTABLE_CHARS.set(95);
        PRINTABLE_CHARS.set(46);
        PRINTABLE_CHARS.set(126);
        PRINTABLE_CHARS.set(32);
    }
}

