/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.attr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.attr.IAttributeContainer;
import com.helger.commons.collection.attr.IMutableAttributeContainer;
import com.helger.commons.collection.attr.MapBasedReadOnlyAttributeContainer;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.ToStringGenerator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MapBasedAttributeContainer<KEYTYPE, VALUETYPE>
extends MapBasedReadOnlyAttributeContainer<KEYTYPE, VALUETYPE>
implements IMutableAttributeContainer<KEYTYPE, VALUETYPE>,
ICloneable<MapBasedAttributeContainer<KEYTYPE, VALUETYPE>> {
    public MapBasedAttributeContainer() {
        this(true, new CommonsHashMap());
    }

    public MapBasedAttributeContainer(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        this(true, new CommonsHashMap());
        this.m_aAttrs.put(KEYTYPE, VALUETYPE);
    }

    public MapBasedAttributeContainer(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        this(true, new CommonsHashMap<KEYTYPE, VALUETYPE>(map));
    }

    public MapBasedAttributeContainer(@Nonnull IAttributeContainer<KEYTYPE, VALUETYPE> iAttributeContainer) {
        this(true, iAttributeContainer.getAllAttributes());
    }

    protected MapBasedAttributeContainer(boolean bl, @Nonnull ICommonsMap<KEYTYPE, VALUETYPE> iCommonsMap) {
        super(bl, iCommonsMap);
    }

    @Override
    @Nonnull
    public final EChange setAttributes(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        EChange eChange = EChange.UNCHANGED;
        if (map != null) {
            for (Map.Entry<KEYTYPE, VALUETYPE> entry : map.entrySet()) {
                eChange = eChange.or(this.setAttribute(entry.getKey(), entry.getValue()));
            }
        }
        return eChange;
    }

    @Override
    @Nonnull
    public final EChange setAttributes(@Nullable IAttributeContainer<? extends KEYTYPE, ? extends VALUETYPE> iAttributeContainer) {
        if (iAttributeContainer == null) {
            return EChange.UNCHANGED;
        }
        return this.setAttributes(iAttributeContainer.getAllAttributes());
    }

    @Nonnull
    @OverrideOnDemand
    protected EContinue onBeforeSetAttributeValue(@Nonnull KEYTYPE KEYTYPE, @Nonnull VALUETYPE VALUETYPE) {
        return EContinue.CONTINUE;
    }

    @Override
    @Nonnull
    public EChange setAttribute(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        ValueEnforcer.notNull(KEYTYPE, "Name");
        if (VALUETYPE == null) {
            return this.removeAttribute(KEYTYPE);
        }
        if (this.onBeforeSetAttributeValue(KEYTYPE, VALUETYPE).isBreak()) {
            return EChange.UNCHANGED;
        }
        VALUETYPE VALUETYPE2 = this.m_aAttrs.put(KEYTYPE, VALUETYPE);
        return EChange.valueOf(!EqualsHelper.equals(VALUETYPE, VALUETYPE2));
    }

    @Nonnull
    @OverrideOnDemand
    protected EContinue onBeforeRemoveAttribute(@Nonnull KEYTYPE KEYTYPE) {
        return EContinue.CONTINUE;
    }

    @Override
    @Nonnull
    public EChange removeAttribute(@Nullable KEYTYPE KEYTYPE) {
        if (KEYTYPE == null) {
            return EChange.UNCHANGED;
        }
        if (this.onBeforeRemoveAttribute(KEYTYPE).isBreak()) {
            return EChange.UNCHANGED;
        }
        return this.m_aAttrs.removeObject(KEYTYPE);
    }

    @Nonnull
    @OverrideOnDemand
    protected EContinue onBeforeRemoveAllAttributes() {
        return EContinue.CONTINUE;
    }

    @Override
    @Nonnull
    public EChange clear() {
        if (this.m_aAttrs.isEmpty()) {
            return EChange.UNCHANGED;
        }
        if (this.onBeforeRemoveAllAttributes().isBreak()) {
            return EChange.UNCHANGED;
        }
        this.m_aAttrs.clear();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public MapBasedAttributeContainer<KEYTYPE, VALUETYPE> getClone() {
        return new MapBasedAttributeContainer<KEYTYPE, VALUETYPE>(this.m_aAttrs);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedAttributeContainer mapBasedAttributeContainer = (MapBasedAttributeContainer)object;
        return this.m_aAttrs.equals(mapBasedAttributeContainer.m_aAttrs);
    }

    @Override
    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aAttrs)).getHashCode();
    }

    @Override
    public String toString() {
        return new ToStringGenerator(this).append("attrs", this.m_aAttrs).toString();
    }
}

