/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.format;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.format.IFormatableObject;
import com.helger.commons.format.IFormatter;
import com.helger.commons.format.IHasFormatter;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FormatableObject<DATATYPE>
implements IFormatableObject<DATATYPE> {
    private final DATATYPE m_aValue;
    private final IFormatter<DATATYPE> m_aFormatter;

    public FormatableObject(@Nullable DATATYPE DATATYPE, @Nullable IFormatter<DATATYPE> iFormatter) {
        this.m_aValue = DATATYPE;
        this.m_aFormatter = iFormatter;
    }

    public FormatableObject(@Nullable DATATYPE DATATYPE, @Nonnull IHasFormatter<DATATYPE> iHasFormatter) {
        this(DATATYPE, iHasFormatter.getFormatter());
    }

    @Override
    @Nullable
    public DATATYPE getValue() {
        return this.m_aValue;
    }

    @Override
    @Nullable
    public IFormatter<DATATYPE> getFormatter() {
        return this.m_aFormatter;
    }

    @Override
    @Nullable
    public String getAsString() {
        return this.m_aFormatter != null ? this.m_aFormatter.apply((Object)this.m_aValue) : String.valueOf(this.m_aValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FormatableObject formatableObject = (FormatableObject)object;
        return EqualsHelper.equals(this.m_aValue, formatableObject.m_aValue) && EqualsHelper.equals(this.m_aFormatter, formatableObject.m_aFormatter);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aValue).append(this.m_aFormatter).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_aValue).appendIfNotNull("formatter", this.m_aFormatter).toString();
    }
}

