/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mime;

import com.helger.commons.annotation.MustImplementComparable;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.EMimeContentType;
import com.helger.commons.mime.EMimeQuoting;
import com.helger.commons.mime.MimeTypeParameter;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@MustImplementEqualsAndHashcode
@MustImplementComparable
public interface IMimeType
extends ICloneable<IMimeType>,
Serializable {
    @Nonnull
    public EMimeContentType getContentType();

    @Nonnull
    public String getContentSubType();

    @Nonnull
    default public String getAsString() {
        return this.getAsString(CMimeType.DEFAULT_QUOTING);
    }

    @Nonnull
    @Nonempty
    public String getAsString(@Nonnull EMimeQuoting var1);

    @Nonnull
    @Nonempty
    public String getAsStringWithoutParameters();

    @Nonnull
    public String getParametersAsString(@Nonnull EMimeQuoting var1);

    public boolean hasAnyParameters();

    @Nonnegative
    public int getParameterCount();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<MimeTypeParameter> getAllParameters();

    @Nullable
    public MimeTypeParameter getParameterAtIndex(@Nonnegative int var1);

    default public boolean hasParameterWithName(@Nullable String string) {
        return this.getParameterWithName(string) != null;
    }

    @Nullable
    public MimeTypeParameter getParameterWithName(@Nullable String var1);

    @Nullable
    public String getParameterValueWithName(@Nullable String var1);

    @Nonnull
    public IMimeType getCopyWithoutParameters();
}

