/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scope.singleton;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.mutable.MutableBoolean;
import com.helger.commons.scope.IScope;
import com.helger.commons.scope.IScopeDestructionAware;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.util.BitSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractSingleton
implements IScopeDestructionAware {
    private static final int STATUS_IN_INSTANTIATION = 0;
    private static final int STATUS_INSTANTIATED = 1;
    private static final int STATUS_IN_PRE_DESTRUCTION = 2;
    private static final int STATUS_IN_DESTRUCTION = 3;
    private static final int STATUS_DESTROYED = 4;
    private static final int DEFAULT_KEY_LENGTH = 255;
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractSingleton.class);
    private static final IMutableStatisticsHandlerKeyedCounter s_aStatsCounterInstantiate = StatisticsManager.getKeyedCounterHandler(AbstractSingleton.class);
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private BitSet m_aStatus = new BitSet(16);

    protected final void writeAbstractSingletonFields(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.m_aStatus);
    }

    protected final void readAbstractSingletonFields(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.m_aStatus = (BitSet)objectInputStream.readObject();
    }

    @UsedViaReflection
    protected AbstractSingleton() {
        if (GlobalDebug.isDebugMode()) {
            boolean bl = false;
            for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                String string = stackTraceElement.getMethodName();
                if (string.equals("getSingleton")) {
                    bl = true;
                    break;
                }
                if (!stackTraceElement.getClassName().equals(ObjectInputStream.class.getName()) || !string.equals("readOrdinaryObject")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IllegalStateException("You cannot instantiate the class " + this.getClass().getName() + " manually! Use the method " + "getSingleton" + " instead!");
            }
        }
    }

    @OverrideOnDemand
    protected void onAfterInstantiation(@Nonnull IScope iScope) {
    }

    protected final void setInInstantiation(boolean bl) {
        this.m_aRWLock.writeLocked(() -> this.m_aStatus.set(0, bl));
    }

    public final boolean isInInstantiation() {
        return this.m_aRWLock.readLocked(() -> this.m_aStatus.get(0));
    }

    protected final void setInstantiated(boolean bl) {
        this.m_aRWLock.writeLocked(() -> this.m_aStatus.set(1, bl));
    }

    public final boolean isInstantiated() {
        return this.m_aRWLock.readLocked(() -> this.m_aStatus.get(1));
    }

    protected final void setInPreDestruction(boolean bl) {
        this.m_aRWLock.writeLocked(() -> this.m_aStatus.set(2, bl));
    }

    public final boolean isInPreDestruction() {
        return this.m_aRWLock.readLocked(() -> this.m_aStatus.get(2));
    }

    protected final void setInDestruction(boolean bl) {
        this.m_aRWLock.writeLocked(() -> this.m_aStatus.set(3, bl));
    }

    public final boolean isInDestruction() {
        return this.m_aRWLock.readLocked(() -> this.m_aStatus.get(3));
    }

    protected final void setDestroyed(boolean bl) {
        this.m_aRWLock.writeLocked(() -> this.m_aStatus.set(4, bl));
    }

    public final boolean isDestroyed() {
        return this.m_aRWLock.readLocked(() -> this.m_aStatus.get(4));
    }

    @OverrideOnDemand
    protected void onBeforeDestroy(@Nonnull IScope iScope) throws Exception {
    }

    @Override
    public final void onBeforeScopeDestruction(@Nonnull IScope iScope) throws Exception {
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("onBeforeScopeDestruction for '" + this.toString() + "' in scope " + iScope.toString());
        }
        if (this.isInInstantiation()) {
            s_aLogger.warn("Object currently in instantiation is destroyed soon: " + this.toString());
        } else if (!this.isInstantiated()) {
            s_aLogger.warn("Object not instantiated is destroyed soon: " + this.toString());
        }
        if (this.isInPreDestruction()) {
            s_aLogger.error("Object already in pre destruction is destroyed soon again: " + this.toString());
        } else if (this.isInDestruction()) {
            s_aLogger.error("Object already in destruction is destroyed soon again: " + this.toString());
        } else if (this.isDestroyed()) {
            s_aLogger.error("Object already destroyed is destroyed soon again: " + this.toString());
        }
        this.setInPreDestruction(true);
        this.onBeforeDestroy(iScope);
    }

    @OverrideOnDemand
    protected void onDestroy(@Nonnull IScope iScope) throws Exception {
    }

    @Override
    public final void onScopeDestruction(@Nonnull IScope iScope) throws Exception {
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("onScopeDestruction for '" + this.toString() + "' in scope " + iScope.toString());
        }
        if (this.isInInstantiation()) {
            s_aLogger.warn("Object currently in instantiation is now destroyed: " + this.toString());
        } else if (!this.isInstantiated()) {
            s_aLogger.warn("Object not instantiated is now destroyed: " + this.toString());
        }
        if (!this.isInPreDestruction()) {
            s_aLogger.error("Object should be in pre destruction phase but is not: " + this.toString());
        }
        if (this.isInDestruction()) {
            s_aLogger.error("Object already in destruction is now destroyed again: " + this.toString());
        } else if (this.isDestroyed()) {
            s_aLogger.error("Object already destroyed is now destroyed again: " + this.toString());
        }
        this.setInDestruction(true);
        this.setInPreDestruction(false);
        try {
            this.onDestroy(iScope);
        }
        finally {
            this.setDestroyed(true);
            this.setInDestruction(false);
        }
    }

    public final boolean isUsableObject() {
        return this.isInstantiated() && !this.isInDestruction() && !this.isDestroyed();
    }

    @Nonnull
    public static final String getSingletonScopeKey(@Nonnull Class<? extends AbstractSingleton> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return new StringBuilder(255).append("singleton.").append(clazz.getName()).toString();
    }

    @Nullable
    public static final <T extends AbstractSingleton> T getSingletonIfInstantiated(@Nullable IScope iScope, @Nonnull Class<T> clazz) {
        AbstractSingleton abstractSingleton;
        String string;
        Object VALUETYPE;
        ValueEnforcer.notNull(clazz, "Class");
        if (iScope != null && (VALUETYPE = iScope.getAttributeObject(string = AbstractSingleton.getSingletonScopeKey(clazz))) != null && (abstractSingleton = (AbstractSingleton)clazz.cast(VALUETYPE)).isUsableObject()) {
            return (T)abstractSingleton;
        }
        return null;
    }

    public static final boolean isSingletonInstantiated(@Nullable IScope iScope, @Nonnull Class<? extends AbstractSingleton> clazz) {
        return AbstractSingleton.getSingletonIfInstantiated(iScope, clazz) != null;
    }

    @Nonnull
    private static <T extends AbstractSingleton> T _instantiateSingleton(@Nonnull Class<T> clazz, @Nonnull IScope iScope) {
        try {
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Created singleton for '" + clazz.toString() + "' in scope " + iScope.toString());
            }
            if (!ClassHelper.isPublicClass(clazz)) {
                throw new IllegalStateException("Class " + clazz.toString() + " is not instancable!");
            }
            try {
                Constructor<T> constructor = clazz.getDeclaredConstructor(IScope.class);
                AbstractSingleton abstractSingleton = (AbstractSingleton)constructor.newInstance(iScope);
                return (T)abstractSingleton;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Constructor<T> constructor = clazz.getDeclaredConstructor(null);
                AbstractSingleton abstractSingleton = (AbstractSingleton)constructor.newInstance(null);
                return (T)abstractSingleton;
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IllegalStateException("Error instantiating singleton of class " + clazz.getName() + " in scope " + iScope.toString(), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static final <T extends AbstractSingleton> T getSingleton(@Nonnull IScope iScope2, @Nonnull Class<T> clazz) {
        ValueEnforcer.notNull(iScope2, "aScope");
        ValueEnforcer.notNull(clazz, "Class");
        String string = AbstractSingleton.getSingletonScopeKey(clazz);
        AbstractSingleton abstractSingleton = (AbstractSingleton)clazz.cast(iScope2.getAttributeObject(string));
        if (abstractSingleton == null) {
            MutableBoolean mutableBoolean = new MutableBoolean(false);
            abstractSingleton = iScope2.runAtomic(iScope -> {
                AbstractSingleton abstractSingleton = (AbstractSingleton)clazz.cast(iScope.getAttributeObject(string));
                if (abstractSingleton == null) {
                    abstractSingleton = AbstractSingleton._instantiateSingleton(clazz, iScope);
                    iScope.setAttribute(string, abstractSingleton);
                    mutableBoolean.set(true);
                    s_aStatsCounterInstantiate.increment(string);
                }
                return abstractSingleton;
            });
            if (mutableBoolean.booleanValue()) {
                abstractSingleton.setInInstantiation(true);
                try {
                    abstractSingleton.onAfterInstantiation(iScope2);
                    abstractSingleton.setInstantiated(true);
                }
                finally {
                    abstractSingleton.setInInstantiation(false);
                }
            }
        }
        return (T)abstractSingleton;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static final <T extends AbstractSingleton> ICommonsList<T> getAllSingletons(@Nullable IScope iScope, @Nonnull Class<T> clazz) {
        ValueEnforcer.notNull(clazz, "DesiredClass");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (iScope != null) {
            for (Object e : iScope.getAllAttributeValues()) {
                if (e == null || !clazz.isAssignableFrom(e.getClass())) continue;
                commonsArrayList.add(clazz.cast(e));
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    public String toString() {
        return new ToStringGenerator(this).append("Status", this.m_aStatus).toString();
    }
}

