/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.decl.CSSFontFaceRule;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSKeyframesRule;
import com.helger.css.decl.CSSMediaRule;
import com.helger.css.decl.CSSNamespaceRule;
import com.helger.css.decl.CSSPageRule;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CSSSupportsRule;
import com.helger.css.decl.CSSUnknownRule;
import com.helger.css.decl.CSSViewportRule;
import com.helger.css.decl.ICSSTopLevelRule;
import java.io.Serializable;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CascadingStyleSheet
implements ICSSSourceLocationAware,
Serializable {
    private final ICommonsList<CSSImportRule> m_aImportRules = new CommonsArrayList();
    private final ICommonsList<CSSNamespaceRule> m_aNamespaceRules = new CommonsArrayList();
    private final ICommonsList<ICSSTopLevelRule> m_aRules = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasImportRules() {
        return this.m_aImportRules.isNotEmpty();
    }

    @Nonnegative
    public int getImportRuleCount() {
        return this.m_aImportRules.size();
    }

    @Nullable
    public CSSImportRule getImportRuleAtIndex(@Nonnegative int n) {
        return (CSSImportRule)this.m_aImportRules.getAtIndex(n);
    }

    @Nonnull
    public CascadingStyleSheet addImportRule(@Nonnull CSSImportRule cSSImportRule) {
        ValueEnforcer.notNull((Object)cSSImportRule, (String)"ImportRule");
        this.m_aImportRules.add((Object)cSSImportRule);
        return this;
    }

    @Nonnull
    public CascadingStyleSheet addImportRule(@Nonnegative int n, @Nonnull CSSImportRule cSSImportRule) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSImportRule, (String)"ImportRule");
        if (n >= this.getImportRuleCount()) {
            this.m_aImportRules.add((Object)cSSImportRule);
        } else {
            this.m_aImportRules.add(n, (Object)cSSImportRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeImportRule(@Nullable CSSImportRule cSSImportRule) {
        return EChange.valueOf((boolean)this.m_aImportRules.remove((Object)cSSImportRule));
    }

    @Nonnull
    public EChange removeImportRule(@Nonnegative int n) {
        return this.m_aImportRules.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllImportRules() {
        return this.m_aImportRules.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSImportRule> getAllImportRules() {
        return (ICommonsList)this.m_aImportRules.getClone();
    }

    public boolean hasNamespaceRules() {
        return this.m_aNamespaceRules.isNotEmpty();
    }

    @Nonnegative
    public int getNamespaceRuleCount() {
        return this.m_aNamespaceRules.size();
    }

    @Nullable
    public CSSNamespaceRule getNamespaceRuleAtIndex(@Nonnegative int n) {
        return (CSSNamespaceRule)this.m_aNamespaceRules.getAtIndex(n);
    }

    @Nonnull
    public CascadingStyleSheet addNamespaceRule(@Nonnull CSSNamespaceRule cSSNamespaceRule) {
        ValueEnforcer.notNull((Object)cSSNamespaceRule, (String)"NamespaceRule");
        this.m_aNamespaceRules.add((Object)cSSNamespaceRule);
        return this;
    }

    @Nonnull
    public CascadingStyleSheet addNamespaceRule(@Nonnegative int n, @Nonnull CSSNamespaceRule cSSNamespaceRule) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSNamespaceRule, (String)"NamespaceRule");
        if (n >= this.getNamespaceRuleCount()) {
            this.m_aNamespaceRules.add((Object)cSSNamespaceRule);
        } else {
            this.m_aNamespaceRules.add(n, (Object)cSSNamespaceRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeNamespaceRule(@Nullable CSSNamespaceRule cSSNamespaceRule) {
        return EChange.valueOf((boolean)this.m_aNamespaceRules.remove((Object)cSSNamespaceRule));
    }

    @Nonnull
    public EChange removeNamespaceRule(@Nonnegative int n) {
        return this.m_aNamespaceRules.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllNamespaceRules() {
        return this.m_aNamespaceRules.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSNamespaceRule> getAllNamespaceRules() {
        return (ICommonsList)this.m_aNamespaceRules.getClone();
    }

    public boolean hasRules() {
        return this.m_aRules.isNotEmpty();
    }

    @Nonnegative
    public int getRuleCount() {
        return this.m_aRules.size();
    }

    @Nullable
    public ICSSTopLevelRule getRuleAtIndex(@Nonnegative int n) {
        return (ICSSTopLevelRule)this.m_aRules.getAtIndex(n);
    }

    @Nonnull
    public CascadingStyleSheet addRule(@Nonnull ICSSTopLevelRule iCSSTopLevelRule) {
        ValueEnforcer.notNull((Object)iCSSTopLevelRule, (String)"Rule");
        this.m_aRules.add((Object)iCSSTopLevelRule);
        return this;
    }

    @Nonnull
    public CascadingStyleSheet addRule(@Nonnegative int n, @Nonnull ICSSTopLevelRule iCSSTopLevelRule) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)iCSSTopLevelRule, (String)"Rule");
        if (n >= this.getRuleCount()) {
            this.m_aRules.add((Object)iCSSTopLevelRule);
        } else {
            this.m_aRules.add(n, (Object)iCSSTopLevelRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeRule(@Nullable ICSSTopLevelRule iCSSTopLevelRule) {
        return EChange.valueOf((boolean)this.m_aRules.remove((Object)iCSSTopLevelRule));
    }

    @Nonnull
    public EChange removeRule(@Nonnegative int n) {
        return this.m_aRules.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeRules(@Nonnull Predicate<? super ICSSTopLevelRule> predicate) {
        return EChange.valueOf((boolean)this.m_aRules.removeIf(predicate));
    }

    @Nonnull
    public EChange removeAllRules() {
        return this.m_aRules.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSTopLevelRule> getAllRules() {
        return (ICommonsList)this.m_aRules.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSTopLevelRule> getAllRules(@Nonnull Predicate<? super ICSSTopLevelRule> predicate) {
        return this.m_aRules.getAll(predicate);
    }

    public boolean hasStyleRules() {
        return this.m_aRules.containsAny(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSStyleRule);
    }

    @Nonnegative
    public int getStyleRuleCount() {
        return this.m_aRules.getCount(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSStyleRule);
    }

    @Nullable
    public CSSStyleRule getStyleRuleAtIndex(@Nonnegative int n) {
        return (CSSStyleRule)this.m_aRules.getAtIndexMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSStyleRule, n, iCSSTopLevelRule -> (CSSStyleRule)iCSSTopLevelRule);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSStyleRule> getAllStyleRules() {
        return this.m_aRules.getAllMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSStyleRule, iCSSTopLevelRule -> (CSSStyleRule)iCSSTopLevelRule);
    }

    public boolean hasPageRules() {
        return this.m_aRules.containsAny(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSPageRule);
    }

    @Nonnegative
    public int getPageRuleCount() {
        return this.m_aRules.getCount(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSPageRule);
    }

    @Nullable
    public CSSPageRule getPageRuleAtIndex(@Nonnegative int n) {
        return (CSSPageRule)this.m_aRules.getAtIndexMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSPageRule, n, iCSSTopLevelRule -> (CSSPageRule)iCSSTopLevelRule);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSPageRule> getAllPageRules() {
        return this.m_aRules.getAllMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSPageRule, iCSSTopLevelRule -> (CSSPageRule)iCSSTopLevelRule);
    }

    public boolean hasMediaRules() {
        return this.m_aRules.containsAny(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSMediaRule);
    }

    @Nonnegative
    public int getMediaRuleCount() {
        return this.m_aRules.getCount(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSMediaRule);
    }

    @Nullable
    public CSSMediaRule getMediaRuleAtIndex(@Nonnegative int n) {
        return (CSSMediaRule)this.m_aRules.getAtIndexMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSMediaRule, n, iCSSTopLevelRule -> (CSSMediaRule)iCSSTopLevelRule);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSMediaRule> getAllMediaRules() {
        return this.m_aRules.getAllMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSMediaRule, iCSSTopLevelRule -> (CSSMediaRule)iCSSTopLevelRule);
    }

    public boolean hasFontFaceRules() {
        return this.m_aRules.containsAny(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSFontFaceRule);
    }

    @Nonnegative
    public int getFontFaceRuleCount() {
        return this.m_aRules.getCount(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSFontFaceRule);
    }

    @Nullable
    public CSSFontFaceRule getFontFaceRuleAtIndex(@Nonnegative int n) {
        return (CSSFontFaceRule)this.m_aRules.getAtIndexMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSFontFaceRule, n, iCSSTopLevelRule -> (CSSFontFaceRule)iCSSTopLevelRule);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSFontFaceRule> getAllFontFaceRules() {
        return this.m_aRules.getAllMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSFontFaceRule, iCSSTopLevelRule -> (CSSFontFaceRule)iCSSTopLevelRule);
    }

    public boolean hasKeyframesRules() {
        return this.m_aRules.containsAny(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSKeyframesRule);
    }

    @Nonnegative
    public int getKeyframesRuleCount() {
        return this.m_aRules.getCount(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSKeyframesRule);
    }

    @Nullable
    public CSSKeyframesRule getKeyframesRuleAtIndex(@Nonnegative int n) {
        return (CSSKeyframesRule)this.m_aRules.getAtIndexMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSKeyframesRule, n, iCSSTopLevelRule -> (CSSKeyframesRule)iCSSTopLevelRule);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSKeyframesRule> getAllKeyframesRules() {
        return this.m_aRules.getAllMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSKeyframesRule, iCSSTopLevelRule -> (CSSKeyframesRule)iCSSTopLevelRule);
    }

    public boolean hasViewportRules() {
        return this.m_aRules.containsAny(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSViewportRule);
    }

    @Nonnegative
    public int getViewportRuleCount() {
        return this.m_aRules.getCount(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSViewportRule);
    }

    @Nullable
    public CSSViewportRule getViewportRuleAtIndex(@Nonnegative int n) {
        return (CSSViewportRule)this.m_aRules.getAtIndexMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSViewportRule, n, iCSSTopLevelRule -> (CSSViewportRule)iCSSTopLevelRule);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSViewportRule> getAllViewportRules() {
        return this.m_aRules.getAllMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSViewportRule, iCSSTopLevelRule -> (CSSViewportRule)iCSSTopLevelRule);
    }

    public boolean hasSupportsRules() {
        return this.m_aRules.containsAny(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSSupportsRule);
    }

    @Nonnegative
    public int getSupportsRuleCount() {
        return this.m_aRules.getCount(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSSupportsRule);
    }

    @Nullable
    public CSSSupportsRule getSupportsRuleAtIndex(@Nonnegative int n) {
        return (CSSSupportsRule)this.m_aRules.getAtIndexMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSSupportsRule, n, iCSSTopLevelRule -> (CSSSupportsRule)iCSSTopLevelRule);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSSupportsRule> getAllSupportsRules() {
        return this.m_aRules.getAllMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSSupportsRule, iCSSTopLevelRule -> (CSSSupportsRule)iCSSTopLevelRule);
    }

    public boolean hasUnknownRules() {
        return this.m_aRules.containsAny(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSUnknownRule);
    }

    @Nonnegative
    public int getUnknownRuleCount() {
        return this.m_aRules.getCount(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSUnknownRule);
    }

    @Nullable
    public CSSUnknownRule getUnknownRuleAtIndex(@Nonnegative int n) {
        return (CSSUnknownRule)this.m_aRules.getAtIndexMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSUnknownRule, n, iCSSTopLevelRule -> (CSSUnknownRule)iCSSTopLevelRule);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSUnknownRule> getAllUnknownRules() {
        return this.m_aRules.getAllMapped(iCSSTopLevelRule -> iCSSTopLevelRule instanceof CSSUnknownRule, iCSSTopLevelRule -> (CSSUnknownRule)iCSSTopLevelRule);
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CascadingStyleSheet cascadingStyleSheet = (CascadingStyleSheet)object;
        return this.m_aImportRules.equals(cascadingStyleSheet.m_aImportRules) && this.m_aNamespaceRules.equals(cascadingStyleSheet.m_aNamespaceRules) && this.m_aRules.equals(cascadingStyleSheet.m_aRules);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aImportRules).append(this.m_aNamespaceRules).append(this.m_aRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("importRules", this.m_aImportRules).append("namespaceRules", this.m_aNamespaceRules).append("rules", this.m_aRules).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

