/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.charset.CCharset;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVersion;
import com.helger.css.handler.ICSSParseExceptionCallback;
import com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CSSReaderSettings
implements ICloneable<CSSReaderSettings> {
    public static final ECSSVersion DEFAULT_VERSION = ECSSVersion.CSS30;
    public static final Charset DEFAULT_CHARSET = CCharset.CHARSET_ISO_8859_1_OBJ;
    public static final boolean DEFAULT_BROWSER_COMPLIANT_MODE = false;
    public static final int DEFAULT_TAB_SIZE = 8;
    private ECSSVersion m_eCSSVersion = DEFAULT_VERSION;
    private Charset m_aFallbackCharset = DEFAULT_CHARSET;
    private ICSSParseErrorHandler m_aCustomErrorHandler;
    private ICSSParseExceptionCallback m_aCustomExceptionHandler;
    private boolean m_bBrowserCompliantMode = false;
    private int m_nTabSize = 8;
    private ICSSInterpretErrorHandler m_aInterpretErrorHandler;

    public CSSReaderSettings() {
    }

    public CSSReaderSettings(@Nonnull CSSReaderSettings cSSReaderSettings) {
        ValueEnforcer.notNull((Object)cSSReaderSettings, (String)"Other");
        this.m_eCSSVersion = cSSReaderSettings.m_eCSSVersion;
        this.m_aFallbackCharset = cSSReaderSettings.m_aFallbackCharset;
        this.m_aCustomErrorHandler = cSSReaderSettings.m_aCustomErrorHandler;
        this.m_aCustomExceptionHandler = cSSReaderSettings.m_aCustomExceptionHandler;
        this.m_bBrowserCompliantMode = cSSReaderSettings.m_bBrowserCompliantMode;
        this.m_nTabSize = cSSReaderSettings.m_nTabSize;
        this.m_aInterpretErrorHandler = cSSReaderSettings.m_aInterpretErrorHandler;
    }

    @Nonnull
    public ECSSVersion getCSSVersion() {
        return this.m_eCSSVersion;
    }

    @Nonnull
    public CSSReaderSettings setCSSVersion(@Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)((Object)eCSSVersion), (String)"CSSVersion");
        this.m_eCSSVersion = eCSSVersion;
        return this;
    }

    @Nonnull
    public Charset getFallbackCharset() {
        return this.m_aFallbackCharset;
    }

    @Nonnull
    public String getFallbackCharsetName() {
        return this.m_aFallbackCharset.name();
    }

    @Nonnull
    public CSSReaderSettings setFallbackCharset(@Nonnull @Nonempty Charset charset) {
        ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
        this.m_aFallbackCharset = charset;
        return this;
    }

    @Nullable
    public ICSSParseErrorHandler getCustomErrorHandler() {
        return this.m_aCustomErrorHandler;
    }

    @Nonnull
    public CSSReaderSettings setCustomErrorHandler(@Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        this.m_aCustomErrorHandler = iCSSParseErrorHandler;
        return this;
    }

    @Nullable
    public ICSSParseExceptionCallback getCustomExceptionHandler() {
        return this.m_aCustomExceptionHandler;
    }

    @Nonnull
    public CSSReaderSettings setCustomExceptionHandler(@Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        this.m_aCustomExceptionHandler = iCSSParseExceptionCallback;
        return this;
    }

    public boolean isBrowserCompliantMode() {
        return this.m_bBrowserCompliantMode;
    }

    @Nonnull
    public CSSReaderSettings setBrowserCompliantMode(boolean bl) {
        this.m_bBrowserCompliantMode = bl;
        return this;
    }

    @Nonnegative
    public int getTabSize() {
        return this.m_nTabSize;
    }

    @Nonnull
    public CSSReaderSettings setTabSize(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"TabSize");
        this.m_nTabSize = n;
        return this;
    }

    @Nullable
    public ICSSInterpretErrorHandler getInterpretErrorHandler() {
        return this.m_aInterpretErrorHandler;
    }

    @Nonnull
    public CSSReaderSettings setInterpretErrorHandler(@Nullable ICSSInterpretErrorHandler iCSSInterpretErrorHandler) {
        this.m_aInterpretErrorHandler = iCSSInterpretErrorHandler;
        return this;
    }

    @Nonnull
    public CSSReaderSettings getClone() {
        return new CSSReaderSettings(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("CSSVersion", (Enum)this.m_eCSSVersion).append("FallbackCharset", (Object)this.m_aFallbackCharset).append("CustomErrorHandler", (Object)this.m_aCustomErrorHandler).append("CustomExceptionHandler", (Object)this.m_aCustomExceptionHandler).append("BrowserCompliantMode", this.m_bBrowserCompliantMode).append("TabSize", this.m_nTabSize).append("InterpretErrorHandler", (Object)this.m_aInterpretErrorHandler).toString();
    }
}

