/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.beetl.core.Configuration;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.SQLTableSource;
import org.beetl.sql.core.annotatoin.AssignID;
import org.beetl.sql.core.annotatoin.AutoID;
import org.beetl.sql.core.annotatoin.DateTemplate;
import org.beetl.sql.core.annotatoin.SeqID;
import org.beetl.sql.core.annotatoin.TableTemplate;
import org.beetl.sql.core.annotatoin.builder.AttributeBuilderHolder;
import org.beetl.sql.core.annotatoin.builder.AttributePersistBuilder;
import org.beetl.sql.core.db.ClassDesc;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.DefaultKeyWordHandler;
import org.beetl.sql.core.db.KeyWordHandler;
import org.beetl.sql.core.db.MetadataManager;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.engine.Beetl;
import org.beetl.sql.core.kit.BeanKit;

public abstract class AbstractDBStyle
implements DBStyle {
    protected NameConversion nameConversion;
    protected MetadataManager metadataManager;
    public String STATEMENT_START;
    public String STATEMENT_END;
    public String HOLDER_START;
    public String HOLDER_END;
    protected String lineSeparator = System.getProperty("line.separator", "\n");
    protected KeyWordHandler keyWordHandler = new DefaultKeyWordHandler();
    protected boolean offsetStartZero = false;

    @Override
    public void init(Beetl beetl) {
        Configuration cf = beetl.getGroupTemplate().getConf();
        this.STATEMENT_START = cf.getStatementStart();
        this.STATEMENT_END = cf.getStatementEnd();
        if (this.STATEMENT_END == null || this.STATEMENT_END.length() == 0) {
            this.STATEMENT_END = this.lineSeparator;
        }
        this.HOLDER_START = cf.getPlaceholderStart();
        this.HOLDER_END = cf.getPlaceholderEnd();
        this.offsetStartZero = Boolean.parseBoolean(beetl.getPs().getProperty("OFFSET_START_ZERO").trim());
    }

    public String getSTATEMENTSTART() {
        return this.STATEMENT_START;
    }

    public String getSTATEMENTEND() {
        return this.STATEMENT_END;
    }

    @Override
    public NameConversion getNameConversion() {
        return this.nameConversion;
    }

    @Override
    public void setNameConversion(NameConversion nameConversion) {
        this.nameConversion = nameConversion;
    }

    @Override
    public MetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    @Override
    public void setMetadataManager(MetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }

    @Override
    public SQLSource genSelectById(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        String condition = this.appendIdCondition(cls);
        return new SQLTableSource("select * from " + this.getTableName(table) + condition);
    }

    @Override
    public SQLSource genSelectByIdForUpdate(Class<?> cls) {
        SQLSource source = this.genSelectById(cls);
        String template = source.getTemplate();
        template = template + " for update";
        source.setTemplate(template);
        return source;
    }

    @Override
    public SQLSource genSelectByTemplate(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        String condition = this.getSelectTemplate(cls);
        String appendSql = "";
        TableTemplate t = (TableTemplate)BeanKit.getAnnotation(cls, TableTemplate.class);
        if (t != null && ((appendSql = t.value()) == null || appendSql.length() == 0) && table.getIdNames().size() != 0) {
            appendSql = " order by ";
            Set<String> ids = table.getIdNames();
            int i = 0;
            for (String id : ids) {
                appendSql = appendSql + id + " desc";
                if (i == ids.size() - 1) break;
                appendSql = appendSql + " , ";
            }
        }
        String sql = "select * from " + this.getTableName(table) + condition + appendSql;
        return new SQLTableSource(sql);
    }

    @Override
    public SQLSource genSelectCountByTemplate(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        String condition = this.getSelectTemplate(cls);
        return new SQLTableSource("select count(1) from " + this.getTableName(table) + condition);
    }

    protected String getSelectTemplate(Class<?> cls) {
        String condition = " where 1=1 " + this.lineSeparator;
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(cls, this.nameConversion);
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> attrs = classDesc.getAttrs().iterator();
        while (cols.hasNext() && attrs.hasNext()) {
            String col = cols.next();
            String attr = attrs.next();
            if (classDesc.isDateType(attr)) {
                try {
                    DateTemplate dateTemplate = BeanKit.getAnnoation(classDesc.getTargetClass(), attr, DateTemplate.class);
                    if (dateTemplate == null) continue;
                    String sql = this.genDateAnnotatonSql(dateTemplate, cls, col);
                    condition = condition + sql;
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("\u83b7\u53d6metod\u51fa\u9519" + e.getMessage());
                }
            }
            condition = condition + this.appendWhere(cls, table, col, attr);
        }
        return condition;
    }

    @Override
    public SQLSource genDeleteById(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(cls, this.nameConversion);
        String condition = this.appendIdCondition(cls);
        if (classDesc.getLogicDeleteAttrName() == null) {
            return new SQLTableSource("delete from " + this.getTableName(table) + condition);
        }
        String col = this.nameConversion.getColName(cls, classDesc.getLogicDeleteAttrName());
        return new SQLTableSource("update  " + this.getTableName(table) + " set " + col + " = " + classDesc.getLogicDeleteAttrValue() + condition);
    }

    @Override
    public SQLSource genSelectAll(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        tableName = table.getName();
        return new SQLTableSource("select * from " + this.getTableName(table));
    }

    @Override
    public SQLSource genUpdateById(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(cls, this.nameConversion);
        StringBuilder sql = new StringBuilder("update ").append(this.getTableName(table)).append(" set ").append(this.lineSeparator);
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> properties = classDesc.getAttrs().iterator();
        List<String> idCols = classDesc.getIdCols();
        while (cols.hasNext() && properties.hasNext()) {
            String col = cols.next();
            String prop = properties.next();
            if (classDesc.isUpdateIgnore(prop) || idCols.contains(col)) continue;
            if (prop.equals(classDesc.getVersionProperty())) {
                sql.append(this.getKeyWordHandler().getCol(col)).append("=").append(this.getKeyWordHandler().getCol(col)).append("+1").append(",");
                continue;
            }
            sql.append(this.appendSetColumnAbsolute(cls, table, col, prop));
        }
        String condition = this.appendIdCondition(cls);
        condition = this.appendVersion(condition, classDesc);
        sql = this.removeComma(sql, condition);
        return new SQLTableSource(sql.toString());
    }

    @Override
    public SQLSource genUpdateAbsolute(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(cls, this.nameConversion);
        StringBuilder sql = new StringBuilder("update ").append(this.getTableName(table)).append(" set ").append(this.lineSeparator);
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> properties = classDesc.getAttrs().iterator();
        List<String> idCols = classDesc.getIdCols();
        while (cols.hasNext() && properties.hasNext()) {
            String col = cols.next();
            String prop = properties.next();
            if (classDesc.isUpdateIgnore(prop) || idCols.contains(col)) continue;
            if (prop.equals(classDesc.getVersionProperty())) {
                sql.append(this.getKeyWordHandler().getCol(col)).append("=").append(this.getKeyWordHandler().getCol(col)).append("+1").append(",");
                continue;
            }
            sql.append(this.appendSetColumnAbsolute(cls, table, col, prop));
        }
        sql = this.removeComma(sql, "");
        return new SQLTableSource(sql.toString());
    }

    private String appendVersion(String condition, ClassDesc desc) {
        String property = desc.getVersionProperty();
        if (property == null) {
            return condition;
        }
        String col = this.nameConversion.getColName(desc.targetClass, property);
        condition = condition + " and " + this.getKeyWordHandler().getCol(col) + " = " + this.HOLDER_START + property + this.HOLDER_END;
        return condition;
    }

    @Override
    public SQLSource genUpdateTemplate(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(cls, this.nameConversion);
        StringBuilder sql = new StringBuilder("update ").append(this.getTableName(table)).append(" set ").append(this.lineSeparator);
        String condition = this.appendIdCondition(cls);
        condition = this.appendVersion(condition, classDesc);
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> properties = classDesc.getAttrs().iterator();
        List<String> idCols = classDesc.getIdCols();
        while (cols.hasNext() && properties.hasNext()) {
            String col = cols.next();
            String prop = properties.next();
            if (classDesc.isUpdateIgnore(prop) || idCols.contains(col)) continue;
            if (prop.equals(classDesc.getVersionProperty())) {
                sql.append(this.getKeyWordHandler().getCol(col)).append("=").append(this.getKeyWordHandler().getCol(col)).append("+1").append(",");
                continue;
            }
            sql.append(this.appendSetColumn(cls, table, col, prop));
        }
        StringBuilder trimSql = new StringBuilder();
        trimSql.append(this.getSTATEMENTSTART()).append("trim(){\n").append(this.getSTATEMENTEND()).append("\n").append((CharSequence)sql);
        trimSql.append(this.getSTATEMENTSTART()).append("}\n").append(this.getSTATEMENTEND());
        sql = this.removeComma(trimSql, condition);
        if (condition == null) {
            throw new BeetlSQLException(4, "\u65e0\u6cd5\u751f\u6210sql\u8bed\u53e5\uff0c\u7f3a\u5c11\u4e3b\u952e");
        }
        return new SQLTableSource(sql.toString());
    }

    @Override
    public SQLSource genUpdateAll(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(cls, this.nameConversion);
        StringBuilder sql = new StringBuilder("update ").append(this.getTableName(table)).append(" set ").append(this.lineSeparator);
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> properties = classDesc.getAttrs().iterator();
        sql.append(this.lineSeparator).append(this.STATEMENT_START);
        sql.append("trim({suffixOverrides:','}){").append(this.lineSeparator);
        List<String> idCols = classDesc.getIdCols();
        while (cols.hasNext() && properties.hasNext()) {
            String col = cols.next();
            String prop = properties.next();
            if (classDesc.isUpdateIgnore(prop) || idCols.contains(col)) continue;
            sql.append(this.appendSetColumn(cls, table, col, prop));
        }
        sql.append(this.lineSeparator).append(this.STATEMENT_START);
        sql.append("}").append(this.lineSeparator).append(this.STATEMENT_END);
        return new SQLTableSource(sql.toString());
    }

    @Override
    public SQLSource genInsert(Class<?> cls) {
        return this.generalInsert(cls, false);
    }

    @Override
    public SQLSource genInsertTemplate(Class<?> cls) {
        return this.generalInsert(cls, true);
    }

    protected SQLSource generalInsert(Class<?> cls, boolean template) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(cls, this.nameConversion);
        StringBuilder sql = new StringBuilder(this.getInsertBaseSql(classDesc, table) + this.lineSeparator);
        StringBuilder colSql = new StringBuilder("(");
        StringBuilder valSql = new StringBuilder(" VALUES (");
        if (template) {
            colSql.append(this.lineSeparator).append(this.STATEMENT_START);
            colSql.append("trim({suffixOverrides:','}){").append(this.lineSeparator);
            valSql.append(this.lineSeparator).append(this.STATEMENT_START);
            valSql.append("trim({suffixOverrides:','}){").append(this.lineSeparator);
        }
        int idType = 1;
        SQLTableSource source = new SQLTableSource();
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> attrs = classDesc.getAttrs().iterator();
        List<String> idCols = classDesc.getIdCols();
        while (cols.hasNext() && attrs.hasNext()) {
            String col = cols.next();
            String attr = attrs.next();
            if (classDesc.isInsertIgnore(attr)) continue;
            if (idCols.size() == 1 && idCols.contains(col)) {
                idType = this.getIdType(classDesc.getTargetClass(), attr);
                if (idType == 2) continue;
                if (idType == 3) {
                    colSql.append(this.appendInsertColumn(cls, table, col));
                    SeqID seqId = BeanKit.getAnnoation(classDesc.getTargetClass(), attr, (Method)classDesc.getIdMethods().get(attr), SeqID.class);
                    valSql.append(this.getSeqValue(seqId.name()) + ",");
                    continue;
                }
                if (idType == 1) {
                    // empty if block
                }
            }
            if (attr.equals(classDesc.getVersionProperty()) && classDesc.getInitVersionValue() != -1) {
                colSql.append(this.appendInsertColumn(cls, table, col));
                valSql.append(classDesc.getInitVersionValue()).append(",");
                continue;
            }
            if (template) {
                colSql.append(this.appendInsertTemplateColumn(cls, table, attr, col));
                valSql.append(this.appendInsertTemplateValue(cls, table, attr, col));
                continue;
            }
            colSql.append(this.appendInsertColumn(cls, table, col));
            valSql.append(this.appendInsertValue(cls, table, attr, col));
        }
        if (template) {
            colSql.append(this.lineSeparator).append(this.STATEMENT_START);
            colSql.append("}").append(this.lineSeparator).append(this.STATEMENT_END);
            colSql.append(")");
            valSql.append(this.lineSeparator).append(this.STATEMENT_START);
            valSql.append("}").append(this.lineSeparator).append(this.STATEMENT_END);
            valSql.append(")");
            sql.append((CharSequence)colSql).append((CharSequence)valSql);
        } else {
            sql.append(this.removeComma(colSql, null).append(")").append((CharSequence)this.removeComma(valSql, null)).append(")").toString());
        }
        source.setTemplate(sql.toString());
        source.setIdType(idType);
        source.setTableDesc(table);
        if (idType == 1) {
            HashMap<String, AssignID> map = new HashMap<String, AssignID>();
            for (String idAttr : classDesc.getIdAttrs()) {
                Method getter = (Method)classDesc.getIdMethods().get(idAttr);
                AssignID assignId = BeanKit.getAnnoation(classDesc.getTargetClass(), idAttr, getter, AssignID.class);
                if (assignId == null || assignId.value().length() == 0) continue;
                map.put(idAttr, assignId);
            }
            if (map.size() != 0) {
                source.setAssignIds(map);
            }
        }
        return source;
    }

    protected String getInsertBaseSql(ClassDesc classDesc, TableDesc table) {
        return "insert into " + this.getTableName(table);
    }

    @Override
    public String genColumnList(String table) {
        Set<String> colSet = this.getCols(table);
        if (null == colSet || colSet.isEmpty()) {
            return "";
        }
        StringBuilder cols = new StringBuilder();
        for (String col : colSet) {
            cols.append(col).append(",");
        }
        return cols.deleteCharAt(cols.length() - 1).toString();
    }

    @Override
    public Set<String> getCols(String tableName) {
        TableDesc table = this.metadataManager.getTable(tableName);
        return table.getCols();
    }

    @Override
    public String genCondition(String tableName) {
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(this.nameConversion);
        Set<String> attrSet = classDesc.getAttrs();
        if (null == attrSet || attrSet.isEmpty()) {
            return "";
        }
        Iterator<String> attrIt = attrSet.iterator();
        Iterator<String> colIt = table.getCols().iterator();
        StringBuilder condition = new StringBuilder();
        Set<String> colsIds = table.getIdNames();
        while (colIt.hasNext() && attrIt.hasNext()) {
            String col = colIt.next();
            String attr = attrIt.next();
            if (colsIds.contains(col)) continue;
            condition.append(this.appendWhere(null, table, col, attr));
        }
        return "1 = 1  \n" + condition.toString();
    }

    @Override
    public String genColAssignProperty(String tableName) {
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(this.nameConversion);
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> properties = classDesc.getAttrs().iterator();
        StringBuilder sql = new StringBuilder();
        while (cols.hasNext() && properties.hasNext()) {
            String col = cols.next();
            String prop = properties.next();
            sql.append(this.appendSetColumn(null, table, col, prop));
        }
        return sql.deleteCharAt(sql.length() - 1).toString();
    }

    @Override
    public String genColAssignPropertyAbsolute(String tableName) {
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(this.nameConversion);
        Set<String> colSet = classDesc.getInCols();
        Set<String> properties = classDesc.getAttrs();
        if (null == colSet || colSet.isEmpty()) {
            return "";
        }
        StringBuilder sql = new StringBuilder();
        Iterator<String> colIt = colSet.iterator();
        Iterator<String> propertiesIt = properties.iterator();
        while (colIt.hasNext() && propertiesIt.hasNext()) {
            String col = colIt.next();
            String prop = propertiesIt.next();
            sql.append(this.appendSetColumnAbsolute(null, table, col, prop));
        }
        return sql.deleteCharAt(sql.length() - 1).toString();
    }

    protected StringBuilder removeComma(StringBuilder sql, String condition) {
        int index = sql.lastIndexOf(",");
        if (index == -1) {
            return sql;
        }
        return sql.deleteCharAt(index).append(condition == null ? "" : condition);
    }

    protected String appendSetColumnAbsolute(Class<?> c, TableDesc table, String colName, String fieldName) {
        String sql = fieldName;
        ClassDesc classDesc = table.getClassDesc(c, this.nameConversion);
        AttributeBuilderHolder handler = (AttributeBuilderHolder)classDesc.getColHandlers().get(fieldName);
        if (handler != null && handler.supportPersistGen()) {
            AttributePersistBuilder baseAttributeBuilder = (AttributePersistBuilder)handler.getInstance();
            sql = baseAttributeBuilder.toSql(this, fieldName, colName, handler.getBeanAnnotaton(), table);
        }
        return this.getKeyWordHandler().getCol(colName) + "=" + this.HOLDER_START + sql + this.HOLDER_END + ",";
    }

    protected String appendSetColumn(Class<?> c, TableDesc table, String colName, String fieldName) {
        String sql = fieldName;
        ClassDesc classDesc = table.getClassDesc(c, this.nameConversion);
        AttributeBuilderHolder handler = (AttributeBuilderHolder)classDesc.getColHandlers().get(fieldName);
        if (handler != null && handler.supportPersistGen()) {
            AttributePersistBuilder baseAttributeBuilder = (AttributePersistBuilder)handler.getInstance();
            sql = baseAttributeBuilder.toSql(this, fieldName, colName, handler.getBeanAnnotaton(), table);
        }
        return this.STATEMENT_START + "if(!isEmpty(" + sql + ")){" + this.STATEMENT_END + "\t" + this.getKeyWordHandler().getCol(colName) + "=" + this.HOLDER_START + sql + this.HOLDER_END + "," + this.lineSeparator + this.STATEMENT_START + "}" + this.STATEMENT_END;
    }

    protected String appendWhere(Class<?> c, TableDesc table, String colName, String fieldName) {
        String prefix = "";
        String connector = " and ";
        return this.STATEMENT_START + "if(!isEmpty(" + prefix + fieldName + ")){" + this.STATEMENT_END + connector + this.getKeyWordHandler().getCol(colName) + "=" + this.HOLDER_START + prefix + fieldName + this.HOLDER_END + this.lineSeparator + this.STATEMENT_START + "}" + this.STATEMENT_END;
    }

    protected String appendInsertColumn(Class<?> c, TableDesc table, String colName) {
        return this.getKeyWordHandler().getCol(colName) + ",";
    }

    protected String appendInsertValue(Class<?> c, TableDesc table, String fieldName, String colName) {
        String sql = fieldName;
        ClassDesc classDesc = table.getClassDesc(c, this.nameConversion);
        AttributeBuilderHolder handler = (AttributeBuilderHolder)classDesc.getColHandlers().get(fieldName);
        if (handler != null && handler.supportPersistGen()) {
            AttributePersistBuilder baseAttributeBuilder = (AttributePersistBuilder)handler.getInstance();
            sql = baseAttributeBuilder.toSql(this, fieldName, colName, handler.getBeanAnnotaton(), table);
        }
        return this.HOLDER_START + sql + this.HOLDER_END + ",";
    }

    protected String appendInsertTemplateColumn(Class<?> c, TableDesc table, String fieldName, String colName) {
        String col = this.getKeyWordHandler().getCol(colName);
        String sql = fieldName;
        ClassDesc classDesc = table.getClassDesc(c, this.nameConversion);
        AttributeBuilderHolder handler = (AttributeBuilderHolder)classDesc.getColHandlers().get(fieldName);
        if (handler != null && handler.supportPersistGen()) {
            AttributePersistBuilder baseAttributeBuilder = (AttributePersistBuilder)handler.getInstance();
            sql = baseAttributeBuilder.toSql(this, fieldName, colName, handler.getBeanAnnotaton(), table);
        }
        if (col.startsWith("'")) {
            return this.HOLDER_START + "db.testColNull(" + sql + ",\"" + col + "\")" + this.HOLDER_END;
        }
        return this.HOLDER_START + "db.testColNull(" + sql + ",'" + col + "')" + this.HOLDER_END;
    }

    protected String appendInsertTemplateValue(Class<?> c, TableDesc table, String fieldName, String colName) {
        String sql = fieldName;
        ClassDesc classDesc = table.getClassDesc(c, this.nameConversion);
        AttributeBuilderHolder handler = (AttributeBuilderHolder)classDesc.getColHandlers().get(fieldName);
        if (handler != null && handler.supportPersistGen()) {
            AttributePersistBuilder baseAttributeBuilder = (AttributePersistBuilder)handler.getInstance();
            sql = baseAttributeBuilder.toSql(this, fieldName, colName, handler.getBeanAnnotaton(), table);
        }
        return this.HOLDER_START + "db.testNull(" + sql + "!,\"" + fieldName + "\")" + this.HOLDER_END;
    }

    protected String appendIdCondition(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        StringBuilder condition = new StringBuilder(" where ");
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(cls, this.nameConversion);
        List<String> colIds = classDesc.getIdCols();
        List<String> propertieIds = classDesc.getIdAttrs();
        this.checkId(colIds, propertieIds, cls.getName());
        Iterator<String> colIt = colIds.iterator();
        Iterator<String> propertieIt = propertieIds.iterator();
        if (colIt.hasNext() && propertieIt.hasNext()) {
            String colId = colIt.next();
            String properId = propertieIt.next();
            condition.append(this.getKeyWordHandler().getCol(colId)).append(" = ").append(this.HOLDER_START).append(properId).append(this.HOLDER_END);
            while (colIt.hasNext() && propertieIt.hasNext()) {
                colId = colIt.next();
                properId = propertieIt.next();
                condition.append(" and ").append(this.getKeyWordHandler().getCol(colId)).append(" = ").append(this.HOLDER_START).append(properId).append(this.HOLDER_END);
            }
        }
        return condition.toString();
    }

    protected String genDateAnnotatonSql(DateTemplate t, Class c, String col) {
        String accept = t.accept();
        String[] vars = null;
        if (accept == null || accept.length() == 0) {
            String col1 = col.substring(0, 1).toUpperCase() + col.substring(1);
            vars = new String[]{"min" + col1, "max" + col1};
        } else {
            vars = t.accept().split(",");
        }
        String[] comp = null;
        String compare = t.compare();
        comp = compare == null || compare.length() == 0 ? new String[]{">=", "<"} : t.compare().split(",");
        String prefix = "";
        String connector = " and ";
        String sql = this.STATEMENT_START + "if(!isEmpty(" + prefix + vars[0] + ")){" + this.STATEMENT_END + connector + col + comp[0] + this.HOLDER_START + vars[0] + this.HOLDER_END + this.lineSeparator + this.STATEMENT_START + "}" + this.STATEMENT_END;
        sql = sql + this.STATEMENT_START + "if(!isEmpty(" + prefix + vars[1] + ")){" + this.STATEMENT_END + connector + col + comp[1] + this.HOLDER_START + vars[1] + this.HOLDER_END + this.lineSeparator + this.STATEMENT_START + "}" + this.STATEMENT_END;
        return sql;
    }

    protected String getTableName(TableDesc desc) {
        String tableName = desc.getName();
        int index = -1;
        index = tableName.indexOf(this.STATEMENT_START);
        if (index != -1) {
            tableName = tableName.substring(0, index) + "\\" + tableName.substring(index);
        }
        if (desc.getSchema() != null) {
            return this.getKeyWordHandler().getTable(desc.getSchema()) + "." + this.getKeyWordHandler().getTable(tableName);
        }
        return this.getKeyWordHandler().getTable(tableName);
    }

    protected void checkId(Collection colsId, Collection attrsId, String clsName) {
        if (colsId.size() == 0 || attrsId.size() == 0) {
            throw new BeetlSQLException(7, "\u4e3b\u952e\u672a\u53d1\u73b0," + clsName + ",\u68c0\u67e5\u6570\u636e\u5e93\u8868\u5b9a\u4e49\u6216\u8005NameConversion");
        }
    }

    protected String getOrderBy() {
        return this.lineSeparator + this.HOLDER_START + "text(has(_orderBy)?' order by '+_orderBy)" + this.HOLDER_END + " ";
    }

    @Override
    public int getIdType(Class c, String idProperty) {
        List<Annotation> ans = BeanKit.getAllAnnoation(c, idProperty);
        int idType = 2;
        for (Annotation an : ans) {
            if (an instanceof AutoID) {
                idType = 2;
                break;
            }
            if (an instanceof SeqID || !(an instanceof AssignID)) continue;
            idType = 1;
        }
        return idType;
    }

    @Override
    public KeyWordHandler getKeyWordHandler() {
        return this.keyWordHandler;
    }

    @Override
    public void setKeyWordHandler(KeyWordHandler keyWordHandler) {
        this.keyWordHandler = keyWordHandler;
    }

    @Override
    public String getSeqValue(String seqName) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5e8f\u5217");
    }
}

