/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext.gen;

import java.io.IOException;
import org.beetl.core.Template;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.kit.GenKit;
import org.beetl.sql.ext.gen.CodeGen;
import org.beetl.sql.ext.gen.GenConfig;
import org.beetl.sql.ext.gen.SourceGen;

public class MapperCodeGen
implements CodeGen {
    String pkg = null;
    private String mapperTemplate = new GenConfig().getTemplate("/org/beetl/sql/ext/gen/mapper.btl");

    public MapperCodeGen() {
    }

    public MapperCodeGen(String pkg) {
        this();
        this.pkg = pkg;
    }

    public String getMapperTemplate() {
        return this.mapperTemplate;
    }

    public void setMapperTemplate(String mapperTemplate) {
        this.mapperTemplate = mapperTemplate;
    }

    @Override
    public void genCode(String entityPkg, String entityClass, TableDesc tableDesc, GenConfig config, boolean isDisplay) {
        if (this.pkg == null) {
            this.pkg = entityPkg;
        }
        Template template = SourceGen.getGt().getTemplate(this.mapperTemplate);
        String mapperClass = entityClass + "Dao";
        template.binding("className", (Object)mapperClass);
        template.binding("package", (Object)this.pkg);
        template.binding("entityClass", (Object)entityClass);
        String mapperHead = "import " + entityPkg + ".*;" + SourceGen.CR;
        template.binding("imports", (Object)mapperHead);
        String mapperCode = template.render();
        if (isDisplay) {
            System.out.println(mapperCode);
        } else {
            try {
                SourceGen.saveSourceFile(GenKit.getJavaSRCPath(), this.pkg, mapperClass, mapperCode);
            }
            catch (IOException e) {
                throw new RuntimeException("mapper\u4ee3\u7801\u751f\u6210\u5931\u8d25", e);
            }
        }
    }
}

