/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.interaction;

import android.view.GestureDetector;
import android.view.MotionEvent;
import com.instabug.library.Instabug;

public class InstabugSwipeDelegate {
    private final InstabugTouchEventForwarder mForwarder;
    private boolean mGoodCycle = false;
    private int mPointerCountNeeded = 0;
    private int mDirectionNeeded;
    private static final int DIRECTION_UP = 1;
    private static final int DIRECTION_DOWN = 2;
    private static final int DIRECTION_LEFT = 3;
    private static final int DIRECTION_RIGHT = 4;

    public InstabugSwipeDelegate(InstabugTouchEventForwarder instabugTouchEventForwarder, GestureConfig gestureConfig) {
        this.mForwarder = instabugTouchEventForwarder;
        if (gestureConfig == null) {
            gestureConfig = GestureConfig.ThreeSwipeUp;
        }
        switch (gestureConfig) {
            case ThreeSwipeUp: {
                this.mDirectionNeeded = 1;
                this.mPointerCountNeeded = 3;
                return;
            }
            case TwoSwipeLeft: {
                this.mDirectionNeeded = 3;
                this.mPointerCountNeeded = 2;
            }
        }
    }

    public void onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getPointerCount() >= this.mPointerCountNeeded) {
            this.mGoodCycle = true;
        }
        int n2 = motionEvent.getAction();
        switch (n2 & 0xFF) {
            case 2: {
                if (motionEvent.getPointerCount() >= this.mPointerCountNeeded) break;
                return;
            }
        }
        this.mForwarder.onInstabugGestureEvent(motionEvent);
    }

    private boolean isDirectionValid(MotionEvent motionEvent, MotionEvent motionEvent2) {
        switch (this.mDirectionNeeded) {
            case 1: {
                return motionEvent.getY() > motionEvent2.getY();
            }
            case 3: {
                return motionEvent.getX() > motionEvent2.getX() && motionEvent.getX() - motionEvent2.getX() >= Math.abs(motionEvent.getY() - motionEvent2.getY());
            }
        }
        return false;
    }

    public static interface InstabugTouchEventForwarder {
        public void onInstabugGestureEvent(MotionEvent var1);
    }

    public class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f2, float f3) {
            if (InstabugSwipeDelegate.this.isDirectionValid(motionEvent, motionEvent2) && InstabugSwipeDelegate.this.mGoodCycle) {
                Instabug.getInstance().invokeFeedbackProcess();
            }
            InstabugSwipeDelegate.this.mGoodCycle = false;
            return false;
        }
    }

    public static enum GestureConfig {
        ThreeSwipeUp,
        TwoSwipeLeft;

    }
}

