/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class InstabugLogger {
    private static final String LOG_FORMAT = "%1$s\n%2$s";
    private static InstabugLogger mInstance;
    private final SimpleDateFormat dateFormatter;
    private StringBuilder sb = new StringBuilder();

    private InstabugLogger() {
        this.dateFormatter = new SimpleDateFormat("MM-dd HH:MM:SS.sss", Locale.US);
    }

    private static synchronized InstabugLogger getInstance() {
        if (mInstance == null) {
            mInstance = new InstabugLogger();
        }
        return mInstance;
    }

    public static String getInstabugLog() {
        return InstabugLogger.getInstance().getLog();
    }

    public static void d(String string2) {
        InstabugLogger.getInstance().log(3, null, null, string2);
    }

    public static void d(String string2, String string3) {
        InstabugLogger.getInstance().log(3, null, string2, string3);
    }

    public static void i(String string2) {
        InstabugLogger.getInstance().log(4, null, null, string2);
    }

    public static void w(String string2) {
        InstabugLogger.getInstance().log(5, null, null, string2);
    }

    public static void e(Throwable throwable) {
        InstabugLogger.getInstance().log(6, throwable, null, null);
    }

    public static void e(String string2, String string3) {
        InstabugLogger.getInstance().log(6, null, string2, string3);
    }

    public static void e(String string2) {
        InstabugLogger.getInstance().log(6, null, null, string2);
    }

    public static void e(String string2, Throwable throwable) {
        InstabugLogger.getInstance().log(6, throwable, null, string2);
    }

    public static void e(String string2, String string3, Throwable throwable) {
        InstabugLogger.getInstance().log(6, throwable, string2, string3);
    }

    public static void log(String string2) {
        InstabugLogger.getInstance().logMessage(string2);
    }

    public static void clear() {
        InstabugLogger.getInstance().sb = new StringBuilder();
    }

    private synchronized void logMessage(String string2) {
        this.sb.append(this.dateFormatter.format(new Date(System.currentTimeMillis())));
        this.sb.append(": ");
        this.sb.append(string2);
        this.sb.append("\n");
    }

    private synchronized void log(int n2, Throwable object, String string2, String string3) {
        this.sb.append(this.dateFormatter.format(new Date(System.currentTimeMillis())));
        this.sb.append("     ");
        switch (n2) {
            case 6: {
                this.sb.append("E/ ");
                break;
            }
            case 3: {
                this.sb.append("D/ ");
                break;
            }
            case 7: {
                this.sb.append("A/ ");
                break;
            }
            case 4: {
                this.sb.append("I/ ");
                break;
            }
            case 5: {
                this.sb.append("W/ ");
                break;
            }
            case 2: {
                this.sb.append("V/ ");
            }
        }
        if (string2 != null) {
            this.sb.append(string2);
            this.sb.append(": ");
        }
        if (object == null) {
            this.sb.append(string3);
            this.sb.append("\n");
            return;
        }
        String string4 = string3 == null ? ((Throwable)object).getMessage() : string3;
        object = Log.getStackTraceString((Throwable)object);
        this.sb.append(String.format(LOG_FORMAT, string4, object));
        this.sb.append("\n");
    }

    public String getLog() {
        return this.sb.toString();
    }
}

