/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.parser;

import com.itextpdf.tool.xml.parser.State;
import com.itextpdf.tool.xml.parser.XMLParser;
import com.itextpdf.tool.xml.parser.state.AttributeValueState;
import com.itextpdf.tool.xml.parser.state.CdataState;
import com.itextpdf.tool.xml.parser.state.CloseCommentState;
import com.itextpdf.tool.xml.parser.state.ClosingTagState;
import com.itextpdf.tool.xml.parser.state.CommentState;
import com.itextpdf.tool.xml.parser.state.DocTypeState;
import com.itextpdf.tool.xml.parser.state.DoubleQuotedAttrValueState;
import com.itextpdf.tool.xml.parser.state.InsideTagHTMLState;
import com.itextpdf.tool.xml.parser.state.InsideTagState;
import com.itextpdf.tool.xml.parser.state.ProcessingInstructionEncounteredState;
import com.itextpdf.tool.xml.parser.state.SelfClosingTagState;
import com.itextpdf.tool.xml.parser.state.SingleQuotedAttrValueState;
import com.itextpdf.tool.xml.parser.state.SpecialCharState;
import com.itextpdf.tool.xml.parser.state.TagAttributeState;
import com.itextpdf.tool.xml.parser.state.TagEncounteredState;
import com.itextpdf.tool.xml.parser.state.UnknownState;
import com.itextpdf.tool.xml.parser.state.UnquotedAttrState;
import com.itextpdf.tool.xml.parser.state.XmlState;

public class StateController {
    private final State unknown;
    private final State tagEncountered;
    private final State tagAttributes;
    private final State inTag;
    private final State attrValue;
    private final State singleQuoted;
    private final State doubleQuoted;
    private final State selfClosing;
    private final State specialChar;
    private final State closingTag;
    private final State comment;
    private final State closeComment;
    private final State cdata;
    private final State xml;
    private final State doctype;
    private final State unquoted;
    private final State processingInstruction;
    private final XMLParser parser;
    private State currentState;
    private State previousState;

    public StateController(XMLParser parser, boolean isHTML) {
        this.parser = parser;
        this.unknown = new UnknownState(parser);
        this.tagEncountered = new TagEncounteredState(parser);
        this.tagAttributes = new TagAttributeState(parser);
        this.inTag = isHTML ? new InsideTagHTMLState(parser) : new InsideTagState(parser);
        this.attrValue = new AttributeValueState(parser);
        this.singleQuoted = new SingleQuotedAttrValueState(parser);
        this.doubleQuoted = new DoubleQuotedAttrValueState(parser);
        this.selfClosing = new SelfClosingTagState(parser);
        this.specialChar = new SpecialCharState(parser);
        this.closingTag = new ClosingTagState(parser);
        this.comment = new CommentState(parser);
        this.closeComment = new CloseCommentState(parser);
        this.cdata = new CdataState(parser);
        this.xml = new XmlState(parser);
        this.doctype = new DocTypeState(parser);
        this.unquoted = new UnquotedAttrState(parser);
        this.processingInstruction = new ProcessingInstructionEncounteredState(parser);
        this.previousState = null;
        this.currentState = null;
    }

    public XMLParser setState(State state) {
        this.previousState = this.currentState;
        this.currentState = state;
        this.parser.setState(state);
        return this.parser;
    }

    public XMLParser previousState() {
        this.parser.setState(this.previousState);
        return this.parser;
    }

    public XMLParser unknown() {
        return this.setState(this.unknown);
    }

    public XMLParser tagEncountered() {
        return this.setState(this.tagEncountered);
    }

    public XMLParser tagAttributes() {
        return this.setState(this.tagAttributes);
    }

    public XMLParser inTag() {
        return this.setState(this.inTag);
    }

    public XMLParser attributeValue() {
        return this.setState(this.attrValue);
    }

    public XMLParser singleQuotedAttr() {
        return this.setState(this.singleQuoted);
    }

    public XMLParser doubleQuotedAttr() {
        return this.setState(this.doubleQuoted);
    }

    public XMLParser processingInstructions() {
        return this.setState(this.processingInstruction);
    }

    public XMLParser selfClosing() {
        return this.setState(this.selfClosing);
    }

    public XMLParser specialChar() {
        return this.setState(this.specialChar);
    }

    public XMLParser closingTag() {
        return this.setState(this.closingTag);
    }

    public XMLParser comment() {
        return this.setState(this.comment);
    }

    public XMLParser closeComment() {
        return this.setState(this.closeComment);
    }

    public XMLParser cdata() {
        return this.setState(this.cdata);
    }

    public XMLParser doctype() {
        return this.setState(this.doctype);
    }

    public XMLParser unquotedAttr() {
        return this.setState(this.unquoted);
    }
}

