/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.authentication;

import com.jayway.restassured.config.LogConfig;
import com.jayway.restassured.filter.log.LogDetail;
import com.jayway.restassured.internal.assertion.AssertParameter;
import org.apache.commons.lang3.StringUtils;

public class FormAuthConfig {
    private final String formAction;
    private final String userInputTagName;
    private final String passwordInputTagName;
    private final LogConfig logConfig;
    private final LogDetail logDetail;
    private final String csrfFieldName;
    private final boolean autoDetectCsrfFieldName;
    private final boolean sendCsrfTokenAsFormParam;

    public FormAuthConfig(String formAction, String userNameInputTagName, String passwordInputTagName) {
        this(formAction, userNameInputTagName, passwordInputTagName, null, null, null, false, true);
    }

    public FormAuthConfig() {
        this(null, null, null);
    }

    private FormAuthConfig(String formAction, String userNameInputTagName, String passwordInputTagName, LogDetail logDetail, LogConfig logConfig, String csrfFieldName, boolean autoDetectCsrfFieldName, boolean sendCsrfTokenAsFormParam) {
        this.formAction = formAction;
        this.userInputTagName = userNameInputTagName;
        this.passwordInputTagName = passwordInputTagName;
        this.logDetail = logDetail;
        this.logConfig = logConfig;
        this.csrfFieldName = csrfFieldName;
        this.autoDetectCsrfFieldName = autoDetectCsrfFieldName;
        this.sendCsrfTokenAsFormParam = sendCsrfTokenAsFormParam;
    }

    public static FormAuthConfig springSecurity() {
        return new FormAuthConfig("/j_spring_security_check", "j_username", "j_password");
    }

    public FormAuthConfig withCsrfFieldName(String fieldName) {
        AssertParameter.notNull((Object)fieldName, (String)"CSRF field name");
        if (this.autoDetectCsrfFieldName) {
            throw new IllegalStateException("Cannot defined a CSRF field name since the CSRF field name has been marked as auto-detected.");
        }
        return new FormAuthConfig(this.formAction, this.userInputTagName, this.passwordInputTagName, this.logDetail, this.logConfig, fieldName, false, this.sendCsrfTokenAsFormParam);
    }

    public FormAuthConfig sendCsrfTokenAsHeader() {
        return new FormAuthConfig(this.formAction, this.userInputTagName, this.passwordInputTagName, this.logDetail, this.logConfig, this.csrfFieldName, this.autoDetectCsrfFieldName, false);
    }

    public FormAuthConfig sendCsrfTokenAsFormParam() {
        return new FormAuthConfig(this.formAction, this.userInputTagName, this.passwordInputTagName, this.logDetail, this.logConfig, this.csrfFieldName, this.autoDetectCsrfFieldName, true);
    }

    public FormAuthConfig withAutoDetectionOfCsrf() {
        if (this.hasCsrfFieldName()) {
            throw new IllegalStateException(String.format("Cannot use auto-detection of CSRF field name since a CSRF field name was already defined as '%s'", this.csrfFieldName));
        }
        return new FormAuthConfig(this.formAction, this.userInputTagName, this.passwordInputTagName, this.logDetail, this.logConfig, this.csrfFieldName, true, this.sendCsrfTokenAsFormParam);
    }

    public FormAuthConfig withLoggingEnabled() {
        return this.withLoggingEnabled(LogDetail.ALL);
    }

    public FormAuthConfig withLoggingEnabled(LogDetail logDetail) {
        return this.withLoggingEnabled(logDetail, new LogConfig());
    }

    public FormAuthConfig withLoggingEnabled(LogConfig logConfig) {
        return this.withLoggingEnabled(LogDetail.ALL, logConfig);
    }

    public FormAuthConfig withLoggingEnabled(LogDetail logDetail, LogConfig logConfig) {
        AssertParameter.notNull((Object)((Object)logDetail), LogDetail.class);
        AssertParameter.notNull((Object)logConfig, LogConfig.class);
        return new FormAuthConfig(this.formAction, this.userInputTagName, this.passwordInputTagName, logDetail, logConfig, this.csrfFieldName, this.autoDetectCsrfFieldName, this.sendCsrfTokenAsFormParam);
    }

    public static FormAuthConfig formAuthConfig() {
        return new FormAuthConfig(null, null, null);
    }

    public FormAuthConfig and() {
        return this;
    }

    public String getFormAction() {
        return this.formAction;
    }

    public String getUserInputTagName() {
        return this.userInputTagName;
    }

    public String getPasswordInputTagName() {
        return this.passwordInputTagName;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public boolean isLoggingEnabled() {
        return this.logConfig != null && this.logDetail != null;
    }

    public LogDetail getLogDetail() {
        return this.logDetail;
    }

    public String getCsrfFieldName() {
        return this.csrfFieldName;
    }

    public boolean hasCsrfFieldName() {
        return StringUtils.isNotBlank((CharSequence)this.csrfFieldName);
    }

    public boolean isAutoDetectCsrfFieldName() {
        return this.autoDetectCsrfFieldName;
    }

    public boolean hasUserInputTagName() {
        return StringUtils.isNotBlank((CharSequence)this.userInputTagName);
    }

    public boolean hasPasswordInputTagName() {
        return StringUtils.isNotBlank((CharSequence)this.passwordInputTagName);
    }

    public boolean hasFormAction() {
        return StringUtils.isNotBlank((CharSequence)this.formAction);
    }

    public boolean requiresParsingOfLoginPage() {
        return !this.hasFormAction() || !this.hasUserInputTagName() || !this.hasPasswordInputTagName() || this.isAutoDetectCsrfFieldName() || this.hasCsrfFieldName();
    }

    public boolean shouldSendCsrfTokenAsFormParam() {
        return this.sendCsrfTokenAsFormParam;
    }
}

