/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.internal.print;

import com.jayway.restassured.filter.log.LogDetail;
import com.jayway.restassured.internal.support.Prettifier;
import com.jayway.restassured.response.Cookies;
import com.jayway.restassured.response.Header;
import com.jayway.restassured.response.Headers;
import com.jayway.restassured.response.ResponseBody;
import com.jayway.restassured.response.ResponseOptions;
import java.io.PrintStream;
import org.apache.commons.lang3.StringUtils;

public class ResponsePrinter {
    private static final String HEADER_NAME_AND_VALUE_SEPARATOR = ": ";

    public static String print(ResponseOptions responseOptions, ResponseBody responseBody, PrintStream stream, LogDetail logDetail, boolean shouldPrettyPrint) {
        Cookies cookies;
        StringBuilder builder = new StringBuilder();
        if (logDetail == LogDetail.ALL || logDetail == LogDetail.STATUS) {
            builder.append(responseOptions.statusLine());
        }
        if (logDetail == LogDetail.ALL || logDetail == LogDetail.HEADERS) {
            Headers headers = responseOptions.headers();
            if (headers.exist()) {
                ResponsePrinter.appendNewLineIfAll(logDetail, builder).append(ResponsePrinter.toString(headers));
            }
        } else if (logDetail == LogDetail.COOKIES && (cookies = responseOptions.detailedCookies()).exist()) {
            ResponsePrinter.appendNewLineIfAll(logDetail, builder).append(cookies.toString());
        }
        if (logDetail == LogDetail.ALL || logDetail == LogDetail.BODY) {
            String responseBodyToAppend = shouldPrettyPrint ? new Prettifier().getPrettifiedBodyIfPossible(responseOptions, responseBody) : responseBody.asString();
            if (logDetail == LogDetail.ALL && !StringUtils.isBlank((CharSequence)responseBodyToAppend)) {
                builder.append("\n\n");
            }
            builder.append(responseBodyToAppend);
        }
        String response = builder.toString();
        stream.println(response);
        return response;
    }

    private static String toString(Headers headers) {
        if (!headers.exist()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Header header : headers) {
            builder.append(header.getName()).append(HEADER_NAME_AND_VALUE_SEPARATOR).append(header.getValue()).append("\n");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    private static StringBuilder appendNewLineIfAll(LogDetail logDetail, StringBuilder builder) {
        if (logDetail == LogDetail.ALL) {
            builder.append("\n");
        }
        return builder;
    }
}

