/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.hikaricp;

import com.jfinal.kit.StrKit;
import com.jfinal.plugin.IPlugin;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;

public class HikariCpPlugin
implements IPlugin,
IDataSourceProvider {
    private String jdbcUrl;
    private String username;
    private String password;
    private boolean autoCommit = true;
    private long connectionTimeout = 30000L;
    private long idleTimeout = 600000L;
    private long maxLifetime = 1800000L;
    private String connectionTestQuery = null;
    private int maximumPoolSize = 10;
    private String poolName = null;
    private boolean readOnly = false;
    private String catalog = null;
    private String connectionInitSql = null;
    private String driverClass = null;
    private String transactionIsolation = null;
    private long validationTimeout = 5000L;
    private long leakDetectionThreshold = 0L;
    private HikariDataSource ds;

    public HikariCpPlugin(String jdbcUrl, String username, String password) {
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
    }

    public HikariCpPlugin(String jdbcUrl, String username, String password, String driverClass) {
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
        this.driverClass = driverClass;
    }

    @Override
    public DataSource getDataSource() {
        return this.ds;
    }

    @Override
    public boolean start() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(this.jdbcUrl);
        config.setUsername(this.username);
        config.setPassword(this.password);
        config.setAutoCommit(this.autoCommit);
        config.setReadOnly(this.readOnly);
        config.setConnectionTimeout(this.connectionTimeout);
        config.setIdleTimeout(this.idleTimeout);
        config.setMaxLifetime(this.maxLifetime);
        config.setMaximumPoolSize(this.maximumPoolSize);
        config.setValidationTimeout(this.validationTimeout);
        if (StrKit.notBlank(this.driverClass)) {
            config.setDriverClassName(this.driverClass);
        }
        if (StrKit.notBlank(this.transactionIsolation)) {
            config.setTransactionIsolation(this.transactionIsolation);
        }
        if (this.leakDetectionThreshold != 0L) {
            config.setLeakDetectionThreshold(this.leakDetectionThreshold);
        }
        if (StrKit.notBlank(this.catalog)) {
            config.setCatalog(this.catalog);
        }
        if (StrKit.notBlank(this.connectionTestQuery)) {
            config.setConnectionTestQuery(this.connectionTestQuery);
        }
        if (StrKit.notBlank(this.poolName)) {
            config.setPoolName(this.poolName);
        }
        if (StrKit.notBlank(this.connectionInitSql)) {
            config.setConnectionInitSql(this.connectionInitSql);
        }
        if (this.jdbcUrl.toLowerCase().contains(":mysql:")) {
            config.addDataSourceProperty("cachePrepStmts", (Object)"true");
            config.addDataSourceProperty("useServerPrepStmts", (Object)"true");
            config.addDataSourceProperty("prepStmtCacheSize", (Object)"256");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        }
        if (this.jdbcUrl.toLowerCase().contains(":postgresql:")) {
            if (this.readOnly) {
                config.addDataSourceProperty("readOnly", (Object)"true");
            }
            config.setConnectionTimeout(0L);
            config.addDataSourceProperty("prepareThreshold", (Object)"3");
            config.addDataSourceProperty("preparedStatementCacheQueries", (Object)"128");
            config.addDataSourceProperty("preparedStatementCacheSizeMiB", (Object)"4");
        }
        this.ds = new HikariDataSource(config);
        return true;
    }

    @Override
    public boolean stop() {
        if (this.ds != null) {
            this.ds.close();
        }
        return true;
    }

    public final void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public final void setUsername(String username) {
        this.username = username;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public final void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public final void setConnectionTimeout(long connectionTimeoutMs) {
        this.connectionTimeout = connectionTimeoutMs;
    }

    public final void setIdleTimeout(long idleTimeoutMs) {
        this.idleTimeout = idleTimeoutMs;
    }

    public final void setMaxLifetime(long maxLifetimeMs) {
        this.maxLifetime = maxLifetimeMs;
    }

    public final void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public final void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public final void setConnectionInitSql(String connectionInitSql) {
        this.connectionInitSql = connectionInitSql;
    }

    public final void setConnectionTestQuery(String connectionTestQuery) {
        this.connectionTestQuery = connectionTestQuery;
    }

    public final void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public final void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public final void setTransactionIsolation(String isolationLevel) {
        this.transactionIsolation = isolationLevel;
    }

    public final void setValidationTimeout(long validationTimeoutMs) {
        this.validationTimeout = validationTimeoutMs;
    }

    public final void setLeakDetectionThreshold(long leakDetectionThresholdMs) {
        this.leakDetectionThreshold = leakDetectionThresholdMs;
    }
}

