/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.redis.serializer;

import com.jfinal.kit.LogKit;
import com.jfinal.plugin.redis.serializer.ISerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import redis.clients.util.SafeEncoder;

public class FstSerializer
implements ISerializer {
    public static final ISerializer me = new FstSerializer();

    @Override
    public byte[] keyToBytes(String key) {
        return SafeEncoder.encode((String)key);
    }

    @Override
    public String keyFromBytes(byte[] bytes) {
        return SafeEncoder.encode((byte[])bytes);
    }

    @Override
    public byte[] fieldToBytes(Object field) {
        return this.valueToBytes(field);
    }

    @Override
    public Object fieldFromBytes(byte[] bytes) {
        return this.valueFromBytes(bytes);
    }

    @Override
    public byte[] valueToBytes(Object value) {
        FSTObjectOutput fstOut = null;
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            fstOut = new FSTObjectOutput((OutputStream)bytesOut);
            fstOut.writeObject(value);
            fstOut.flush();
            byte[] byArray = bytesOut.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fstOut != null) {
                try {
                    fstOut.close();
                }
                catch (IOException e) {
                    LogKit.error(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public Object valueFromBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        FSTObjectInput fstInput = null;
        try {
            fstInput = new FSTObjectInput((InputStream)new ByteArrayInputStream(bytes));
            Object object = fstInput.readObject();
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fstInput != null) {
                try {
                    fstInput.close();
                }
                catch (IOException e) {
                    LogKit.error(e.getMessage(), e);
                }
            }
        }
    }
}

