/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import com.jfinal.render.RenderManager;
import java.io.IOException;
import java.io.PrintWriter;

public class ErrorRender
extends Render {
    protected static final String contentType = "text/html; charset=" + ErrorRender.getEncoding();
    protected static final String version = "<center><a href='http://www.jfinal.com?f=ev-3.4' target='_blank'><b>Powered by JFinal 3.4</b></a></center>";
    protected static final String html404 = "<html><head><title>404 Not Found</title></head><body bgcolor='white'><center><h1>404 Not Found</h1></center><hr><center><a href='http://www.jfinal.com?f=ev-3.4' target='_blank'><b>Powered by JFinal 3.4</b></a></center></body></html>";
    protected static final String html500 = "<html><head><title>500 Internal Server Error</title></head><body bgcolor='white'><center><h1>500 Internal Server Error</h1></center><hr><center><a href='http://www.jfinal.com?f=ev-3.4' target='_blank'><b>Powered by JFinal 3.4</b></a></center></body></html>";
    protected static final String html401 = "<html><head><title>401 Unauthorized</title></head><body bgcolor='white'><center><h1>401 Unauthorized</h1></center><hr><center><a href='http://www.jfinal.com?f=ev-3.4' target='_blank'><b>Powered by JFinal 3.4</b></a></center></body></html>";
    protected static final String html403 = "<html><head><title>403 Forbidden</title></head><body bgcolor='white'><center><h1>403 Forbidden</h1></center><hr><center><a href='http://www.jfinal.com?f=ev-3.4' target='_blank'><b>Powered by JFinal 3.4</b></a></center></body></html>";
    protected int errorCode;

    public ErrorRender(int errorCode, String view) {
        this.errorCode = errorCode;
        this.view = view;
    }

    @Override
    public void render() {
        this.response.setStatus(this.getErrorCode());
        String view = this.getView();
        if (view != null) {
            RenderManager.me().getRenderFactory().getRender(view).setContext(this.request, this.response).render();
            return;
        }
        PrintWriter writer = null;
        try {
            this.response.setContentType(contentType);
            writer = this.response.getWriter();
            writer.write(this.getErrorHtml());
            writer.flush();
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
    }

    public String getErrorHtml() {
        int errorCode = this.getErrorCode();
        if (errorCode == 404) {
            return html404;
        }
        if (errorCode == 500) {
            return html500;
        }
        if (errorCode == 401) {
            return html401;
        }
        if (errorCode == 403) {
            return html403;
        }
        return "<html><head><title>" + errorCode + " Error</title></head><body bgcolor='white'><center><h1>" + errorCode + " Error</h1></center><hr>" + version + "</body></html>";
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

