/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.source;

import com.jfinal.kit.HashKit;
import com.jfinal.kit.StrKit;
import com.jfinal.template.source.ISource;

public class StringSource
implements ISource {
    private String key;
    private StringBuilder content;

    public StringSource(String content, boolean cache) {
        if (StrKit.isBlank(content)) {
            throw new IllegalArgumentException("content can not be blank");
        }
        this.content = new StringBuilder(content);
        this.key = cache ? HashKit.md5(content) : null;
    }

    public StringSource(StringBuilder content, boolean cache) {
        if (content == null || content.length() == 0) {
            throw new IllegalArgumentException("content can not be blank");
        }
        this.content = content;
        this.key = cache ? HashKit.md5(content.toString()) : null;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public StringBuilder getContent() {
        return this.content;
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Key : ").append(this.key).append("\n");
        sb.append("Content : ").append((CharSequence)this.content).append("\n");
        return sb.toString();
    }
}

