/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis;

import com.lordofthejars.nosqlunit.core.AbstractNoSqlTestRule;
import com.lordofthejars.nosqlunit.core.DatabaseOperation;
import com.lordofthejars.nosqlunit.redis.AbstractRedisConfiguration;
import com.lordofthejars.nosqlunit.redis.EmbeddedRedisConfigurationBuilder;
import com.lordofthejars.nosqlunit.redis.ManagedRedisConfigurationBuilder;
import redis.clients.jedis.BinaryJedisCommands;

public class RedisRule
extends AbstractNoSqlTestRule {
    private static final String EXTENSION = "json";
    private DatabaseOperation<? extends BinaryJedisCommands> databaseOperation;

    public RedisRule(AbstractRedisConfiguration redisConfiguration) {
        super(redisConfiguration.getConnectionIdentifier());
        this.databaseOperation = redisConfiguration.getDatabaseOperation();
    }

    public RedisRule(AbstractRedisConfiguration redisConfiguration, Object target) {
        this(redisConfiguration);
        this.setTarget(target);
    }

    public DatabaseOperation<? extends BinaryJedisCommands> getDatabaseOperation() {
        return this.databaseOperation;
    }

    public String getWorkingExtension() {
        return EXTENSION;
    }

    public static class RedisRuleBuilder {
        private AbstractRedisConfiguration redisConfiguration;
        private Object target;

        private RedisRuleBuilder() {
        }

        public static RedisRuleBuilder newRedisRule() {
            return new RedisRuleBuilder();
        }

        public RedisRuleBuilder configure(AbstractRedisConfiguration redisConfiguration) {
            this.redisConfiguration = redisConfiguration;
            return this;
        }

        public RedisRuleBuilder unitInstance(Object target) {
            this.target = target;
            return this;
        }

        public RedisRule defaultManagedRedis() {
            return new RedisRule(ManagedRedisConfigurationBuilder.newManagedRedisConfiguration().build());
        }

        public RedisRule defaultManagedRedis(int port) {
            return new RedisRule(ManagedRedisConfigurationBuilder.newManagedRedisConfiguration().port(port).build());
        }

        @Deprecated
        public RedisRule defaultManagedRedis(Object target) {
            return new RedisRule(ManagedRedisConfigurationBuilder.newManagedRedisConfiguration().build(), target);
        }

        public RedisRule defaultEmbeddedRedis() {
            return new RedisRule(EmbeddedRedisConfigurationBuilder.newEmbeddedRedisConfiguration().build());
        }

        @Deprecated
        public RedisRule defaultEmbeddedRedis(Object target) {
            return new RedisRule(EmbeddedRedisConfigurationBuilder.newEmbeddedRedisConfiguration().build(), target);
        }

        public RedisRule build() {
            if (this.redisConfiguration == null) {
                throw new IllegalArgumentException("Configuration object should be provided.");
            }
            return new RedisRule(this.redisConfiguration, this.target);
        }
    }
}

