/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis.embedded;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class MatchesGlobRegexpMatcher
extends TypeSafeMatcher<String> {
    protected final String regex;

    public MatchesGlobRegexpMatcher(String regex) {
        this.regex = regex;
    }

    private boolean match(String pattern, String string) {
        return this.match(pattern, string, null);
    }

    private boolean match(String pattern, String string, String[] substr) {
        return this.match(pattern, 0, string, 0, substr, 0);
    }

    private boolean match(String pat, int pIndex, String str, int sIndex, String[] substrs, int subIndex) {
        int pLen = pat.length();
        int sLen = str.length();
        block8: while (pIndex != pLen) {
            if (sIndex == sLen && pat.charAt(pIndex) != '*') {
                return false;
            }
            switch (pat.charAt(pIndex)) {
                case '*': {
                    int start = sIndex;
                    if (++pIndex >= pLen) {
                        this.addMatch(str, start, sLen, substrs, subIndex);
                        return true;
                    }
                    while (true) {
                        if (this.match(pat, pIndex, str, sIndex, substrs, subIndex + 1)) {
                            this.addMatch(str, start, sIndex, substrs, subIndex);
                            return true;
                        }
                        if (sIndex == sLen) {
                            return false;
                        }
                        ++sIndex;
                    }
                }
                case '?': {
                    ++pIndex;
                    this.addMatch(str, sIndex, sIndex + 1, substrs, subIndex++);
                    ++sIndex;
                    continue block8;
                }
                case '[': {
                    try {
                        char s = str.charAt(sIndex);
                        char p = pat.charAt(++pIndex);
                        while (true) {
                            char next;
                            if (p == ']') {
                                return false;
                            }
                            if (p == s) break;
                            if ((next = pat.charAt(++pIndex)) == '-') {
                                char p2 = pat.charAt(++pIndex);
                                if (p <= s && s <= p2) break;
                                next = pat.charAt(++pIndex);
                            }
                            p = next;
                        }
                        if ((pIndex = pat.indexOf(93, pIndex) + 1) <= 0) {
                            return false;
                        }
                        this.addMatch(str, sIndex, sIndex + 1, substrs, subIndex++);
                        ++sIndex;
                        continue block8;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        return false;
                    }
                }
                case '\\': {
                    if (++pIndex < pLen) break;
                    return false;
                }
            }
            if (pat.charAt(pIndex) != str.charAt(sIndex)) {
                return false;
            }
            ++pIndex;
            ++sIndex;
        }
        return sIndex == sLen;
    }

    private void addMatch(String str, int start, int end, String[] substrs, int subIndex) {
        if (substrs == null || subIndex >= substrs.length) {
            return;
        }
        substrs[subIndex] = str.substring(start, end);
    }

    public void describeTo(Description description) {
        description.appendText("matches regex ").appendValue((Object)this.regex);
    }

    protected boolean matchesSafely(String item) {
        return this.match(this.regex, item);
    }

    public static Matcher<String> matches(String regex) {
        return new MatchesGlobRegexpMatcher(regex);
    }
}

