/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis.embedded;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.lordofthejars.nosqlunit.redis.embedded.BitsUtils;
import com.lordofthejars.nosqlunit.redis.embedded.ByteBuffer2ByteArrayConverter;
import com.lordofthejars.nosqlunit.redis.embedded.ExpirationDatatypeOperations;
import com.lordofthejars.nosqlunit.redis.embedded.RangeUtils;
import com.lordofthejars.nosqlunit.redis.embedded.RedisDatatypeOperations;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import redis.clients.util.SafeEncoder;

public class StringDatatypeOperations
extends ExpirationDatatypeOperations
implements RedisDatatypeOperations {
    protected static final String STRING = "string";
    private static final int NEGATE = -1;
    private static final long NONE_SUCCESS = 0L;
    private static final long SUCCESS = 1L;
    private static final String OK = "OK";
    private static final ByteBuffer ZERO = ByteBuffer.wrap("0".getBytes());
    protected Map<ByteBuffer, ByteBuffer> simpleTypes = new HashMap<ByteBuffer, ByteBuffer>();

    public Long append(byte[] key, byte[] value) {
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        if (this.simpleTypes.containsKey(wrappedKey)) {
            byte[] oldValue = this.simpleTypes.get(wrappedKey).array();
            byte[] newValue = RangeUtils.concat(oldValue, value);
            this.simpleTypes.put(wrappedKey, ByteBuffer.wrap(newValue));
            return newValue.length;
        }
        this.set(key, value);
        return value.length;
    }

    public Long decr(byte[] key) {
        return this.decrBy(key, 1L);
    }

    public Long decrBy(byte[] key, long integer) {
        long value = this.invertSign(integer);
        if (this.simpleTypes.containsKey(ByteBuffer.wrap(key))) {
            return this.incrementAndSetValue(key, value);
        }
        this.simpleTypes.put(ByteBuffer.wrap(key), ZERO);
        return this.incrementAndSetValue(key, value);
    }

    private long invertSign(long integer) {
        long value = integer * -1L;
        return value;
    }

    public Long incrBy(byte[] key, long integer) {
        if (this.simpleTypes.containsKey(ByteBuffer.wrap(key))) {
            return this.incrementAndSetValue(key, integer);
        }
        this.simpleTypes.put(ByteBuffer.wrap(key), ZERO);
        return this.incrementAndSetValue(key, integer);
    }

    public Long incr(byte[] key) {
        return this.incrBy(key, 1L);
    }

    private long incrementAndSetValue(byte[] key, long integer) {
        byte[] oldValue = this.simpleTypes.get(ByteBuffer.wrap(key)).array();
        long newValue = this.incrementValue(oldValue, integer);
        byte[] newValueByteArray = SafeEncoder.encode((String)Long.toString(newValue));
        this.simpleTypes.put(ByteBuffer.wrap(key), ByteBuffer.wrap(newValueByteArray));
        return newValue;
    }

    private long incrementValue(byte[] value, long increment) {
        String numberEncode = SafeEncoder.encode((byte[])value);
        long longValue = Long.parseLong(numberEncode);
        return longValue += increment;
    }

    public Boolean getbit(byte[] key, long offset) {
        if (this.simpleTypes.containsKey(ByteBuffer.wrap(key))) {
            try {
                byte[] value = this.simpleTypes.get(ByteBuffer.wrap(key)).array();
                int bit = BitsUtils.getBit(value, (int)offset);
                return BitsUtils.toBoolean(bit);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return Boolean.FALSE;
            }
        }
        return Boolean.FALSE;
    }

    public Boolean setbit(byte[] key, long offset, byte[] value) {
        boolean originalValue = this.getbit(key, offset);
        int realValue = Integer.parseInt(SafeEncoder.encode((byte[])value));
        int numberOfBytesRequired = BitsUtils.calculateNumberOfBytes((int)offset);
        if (this.simpleTypes.containsKey(ByteBuffer.wrap(key))) {
            byte[] currentValue = this.simpleTypes.get(ByteBuffer.wrap(key)).array();
            if (numberOfBytesRequired > currentValue.length) {
                currentValue = BitsUtils.extendByteArrayBy(currentValue, numberOfBytesRequired - currentValue.length);
            }
            BitsUtils.setBit(currentValue, (int)offset, realValue);
            this.simpleTypes.put(ByteBuffer.wrap(key), ByteBuffer.wrap(currentValue));
            return originalValue;
        }
        byte[] values = new byte[numberOfBytesRequired];
        BitsUtils.setBit(values, (int)offset, realValue);
        this.simpleTypes.put(ByteBuffer.wrap(key), ByteBuffer.wrap(values));
        return Boolean.FALSE;
    }

    public Long setrange(byte[] key, long offset, byte[] value) {
        if (this.simpleTypes.containsKey(ByteBuffer.wrap(key))) {
            byte[] currentValue = this.simpleTypes.get(ByteBuffer.wrap(key)).array();
            if (offset + (long)value.length > (long)currentValue.length) {
                currentValue = BitsUtils.extendByteArrayBy(currentValue, (int)(offset + (long)value.length - (long)currentValue.length));
            }
            System.arraycopy(value, 0, currentValue, (int)offset, value.length);
            this.simpleTypes.put(ByteBuffer.wrap(key), ByteBuffer.wrap(currentValue));
            return currentValue.length;
        }
        return this.append(key, value);
    }

    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        if (this.simpleTypes.containsKey(ByteBuffer.wrap(key))) {
            byte[] value = this.simpleTypes.get(ByteBuffer.wrap(key)).array();
            int calculatedStart = RangeUtils.calculateStart((int)startOffset, value.length);
            int calculatedEnd = RangeUtils.calculateEnd((int)endOffset, value.length);
            try {
                return Arrays.copyOfRange(value, calculatedStart, calculatedEnd);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return SafeEncoder.encode((String)"");
            }
            catch (IllegalArgumentException e) {
                return SafeEncoder.encode((String)"");
            }
        }
        return SafeEncoder.encode((String)"");
    }

    public String mset(byte[] ... keysvalues) {
        if (keysvalues.length % 2 != 0) {
            return null;
        }
        for (int index = 0; index < keysvalues.length; index += 2) {
            this.simpleTypes.put(ByteBuffer.wrap(keysvalues[index]), ByteBuffer.wrap(keysvalues[index + 1]));
        }
        return OK;
    }

    public Long msetnx(byte[] ... keysvalues) {
        int index;
        for (index = 0; index < keysvalues.length; index += 2) {
            if (!this.simpleTypes.containsKey(ByteBuffer.wrap(keysvalues[index]))) continue;
            return 0L;
        }
        for (index = 0; index < keysvalues.length; index += 2) {
            this.simpleTypes.put(ByteBuffer.wrap(keysvalues[index]), ByteBuffer.wrap(keysvalues[index + 1]));
        }
        return 1L;
    }

    public int strlen(byte[] key) {
        ByteBuffer byteBufferKey = ByteBuffer.wrap(key);
        if (!this.simpleTypes.containsKey(byteBufferKey)) {
            return 0;
        }
        return this.simpleTypes.get(byteBufferKey).array().length;
    }

    public String rename(byte[] oldKey, byte[] newKey) {
        if (Arrays.equals(oldKey, newKey) || !this.simpleTypes.containsKey(ByteBuffer.wrap(oldKey))) {
            return null;
        }
        ByteBuffer value = this.simpleTypes.get(oldKey);
        this.simpleTypes.remove(oldKey);
        this.simpleTypes.put(ByteBuffer.wrap(newKey), value);
        this.renameTtlKey(oldKey, newKey);
        return OK;
    }

    public List<byte[]> mget(byte[] ... keys) {
        ArrayList<byte[]> values = new ArrayList<byte[]>();
        for (byte[] key : keys) {
            if (this.simpleTypes.get(ByteBuffer.wrap(key)) == null) {
                values.add(null);
                continue;
            }
            values.add(this.simpleTypes.get(ByteBuffer.wrap(key)).array());
        }
        return values;
    }

    public byte[] get(byte[] key) {
        return this.simpleTypes.get(ByteBuffer.wrap(key)) == null ? null : this.simpleTypes.get(ByteBuffer.wrap(key)).array();
    }

    public byte[] getSet(byte[] key, byte[] value) {
        ByteBuffer byteBufferKey = ByteBuffer.wrap(key);
        if (!this.simpleTypes.containsKey(byteBufferKey)) {
            this.simpleTypes.put(ByteBuffer.wrap(key), ByteBuffer.wrap(value));
            return null;
        }
        ByteBuffer oldValue = this.simpleTypes.get(byteBufferKey);
        this.simpleTypes.put(ByteBuffer.wrap(key), ByteBuffer.wrap(value));
        return oldValue.array();
    }

    public String set(byte[] key, byte[] value) {
        this.simpleTypes.put(ByteBuffer.wrap(key), ByteBuffer.wrap(value));
        return OK;
    }

    public Long setnx(byte[] key, byte[] value) {
        ByteBuffer byteBufferKey = ByteBuffer.wrap(key);
        if (!this.simpleTypes.containsKey(byteBufferKey)) {
            this.set(key, value);
            return 1L;
        }
        return 0L;
    }

    public String setex(byte[] key, int seconds, byte[] value) {
        String result = this.set(key, value);
        this.addExpirationTime(key, seconds, TimeUnit.SECONDS);
        return result;
    }

    public byte[] substr(byte[] key, int start, int end) {
        return this.getrange(key, start, end);
    }

    @Override
    public long getNumberOfKeys() {
        return this.simpleTypes.keySet().size();
    }

    @Override
    public void flushAllKeys() {
        this.removeExpirations();
        this.simpleTypes.clear();
    }

    private void removeExpirations() {
        List<byte[]> keys = this.keys();
        for (byte[] key : keys) {
            this.removeExpiration(key);
        }
    }

    @Override
    public Long del(byte[] ... keys) {
        long numberOfRemovedElements = 0L;
        for (byte[] key : keys) {
            ByteBuffer wrappedKey = ByteBuffer.wrap(key);
            if (!this.simpleTypes.containsKey(wrappedKey)) continue;
            this.simpleTypes.remove(wrappedKey);
            this.removeExpiration(key);
            ++numberOfRemovedElements;
        }
        return numberOfRemovedElements;
    }

    @Override
    public boolean exists(byte[] key) {
        return this.simpleTypes.containsKey(ByteBuffer.wrap(key));
    }

    @Override
    public boolean renameKey(byte[] key, byte[] newKey) {
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        if (this.simpleTypes.containsKey(wrappedKey)) {
            ByteBuffer element = this.simpleTypes.get(wrappedKey);
            this.simpleTypes.remove(ByteBuffer.wrap(newKey));
            this.simpleTypes.put(ByteBuffer.wrap(newKey), element);
            this.simpleTypes.remove(wrappedKey);
            this.renameTtlKey(key, newKey);
            return true;
        }
        return false;
    }

    @Override
    public List<byte[]> keys() {
        return new ArrayList<byte[]>(Lambda.convert(this.simpleTypes.keySet(), (Converter)ByteBuffer2ByteArrayConverter.createByteBufferConverter()));
    }

    @Override
    public String type() {
        return STRING;
    }

    @Override
    public List<byte[]> sort(byte[] key) {
        throw new UnsupportedOperationException();
    }
}

