/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis.parser;

import com.lordofthejars.nosqlunit.redis.parser.JsonToJedisConverter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import redis.clients.jedis.BinaryJedisCommands;

public class DataReader {
    public static final String SCORE_TOKEN = "score";
    public static final String SORTSET_TOKEN = "sortset";
    public static final String VALUES_TOKEN = "values";
    public static final String LIST_TOKEN = "list";
    public static final String VALUE_TOKEN = "value";
    public static final String KEY_TOKEN = "key";
    public static final String SIMPLE_TOKEN = "simple";
    public static final String DATA_TOKEN = "data";
    public static final String HASH_TOKEN = "hash";
    public static final String FIELD_TOKEN = "field";
    public static final String EXPIRE_SEC_TOKEN = "expireSeconds";
    public static final String EXPIRE_AT_SEC_TOKEN = "expireAtSeconds";
    public static final String SET_TOKEN = "set";
    private BinaryJedisCommands jedis;

    public DataReader(BinaryJedisCommands jedis) {
        this.jedis = jedis;
    }

    public void read(InputStream data) {
        Object parse = JSONValue.parse((Reader)new InputStreamReader(data));
        JSONObject rootObject = (JSONObject)parse;
        JSONArray dataObject = (JSONArray)rootObject.get((Object)DATA_TOKEN);
        for (Object object : dataObject) {
            JSONObject elementObject = (JSONObject)object;
            if (elementObject.containsKey((Object)SIMPLE_TOKEN)) {
                this.addSimpleValues(elementObject);
                continue;
            }
            if (elementObject.containsKey((Object)LIST_TOKEN)) {
                this.addListsElement(elementObject);
                continue;
            }
            if (elementObject.containsKey((Object)SORTSET_TOKEN)) {
                this.addSortSetsElement(elementObject);
                continue;
            }
            if (elementObject.containsKey((Object)HASH_TOKEN)) {
                this.addHashesElement(elementObject);
                continue;
            }
            if (!elementObject.containsKey((Object)SET_TOKEN)) continue;
            this.addSetsElement(elementObject);
        }
    }

    private void addHashesElement(JSONObject hashesObject) {
        JSONArray sortsetsObject = (JSONArray)hashesObject.get((Object)HASH_TOKEN);
        for (Object object : sortsetsObject) {
            JSONObject hashObject = (JSONObject)object;
            this.addHashElements(hashObject);
        }
    }

    private void addHashElements(JSONObject hashesObject) {
        Object key = hashesObject.get((Object)KEY_TOKEN);
        JSONArray valuesArray = (JSONArray)hashesObject.get((Object)VALUES_TOKEN);
        HashMap<byte[], byte[]> fields = new HashMap<byte[], byte[]>();
        for (Object object : valuesArray) {
            JSONObject fieldObject = (JSONObject)object;
            fields.put(JsonToJedisConverter.toByteArray(fieldObject.get((Object)FIELD_TOKEN)), JsonToJedisConverter.toByteArray(fieldObject.get((Object)VALUE_TOKEN)));
        }
        this.jedis.hmset(JsonToJedisConverter.toByteArray(key), fields);
        this.setTTL(hashesObject, key);
    }

    private void addSortSetsElement(JSONObject elementObject) {
        JSONArray sortsetsObject = (JSONArray)elementObject.get((Object)SORTSET_TOKEN);
        for (Object object : sortsetsObject) {
            JSONObject sortsetObject = (JSONObject)object;
            this.addSortSetElements(sortsetObject);
        }
    }

    private void addSortSetElements(JSONObject sortsetObject) {
        Object key = sortsetObject.get((Object)KEY_TOKEN);
        JSONArray valuesArray = (JSONArray)sortsetObject.get((Object)VALUES_TOKEN);
        HashMap<Double, byte[]> scoreMembers = new HashMap<Double, byte[]>();
        for (Object valueObject : valuesArray) {
            JSONObject valueScopeObject = (JSONObject)valueObject;
            scoreMembers.put(JsonToJedisConverter.toDouble(valueScopeObject.get((Object)SCORE_TOKEN)), JsonToJedisConverter.toByteArray(valueScopeObject.get((Object)VALUE_TOKEN)));
        }
        this.jedis.zadd(JsonToJedisConverter.toByteArray(key), scoreMembers);
        this.setTTL(sortsetObject, key);
    }

    private void addSetsElement(JSONObject elementObject) {
        JSONArray setObjects = (JSONArray)elementObject.get((Object)SET_TOKEN);
        for (Object object : setObjects) {
            JSONObject setObject = (JSONObject)object;
            this.addSetElements(setObject);
        }
    }

    private void addSetElements(JSONObject setObject) {
        JSONArray valuesArray = (JSONArray)setObject.get((Object)VALUES_TOKEN);
        List<byte[]> listValues = this.extractListOfValues(valuesArray);
        Object key = setObject.get((Object)KEY_TOKEN);
        this.jedis.sadd(JsonToJedisConverter.toByteArray(key), (byte[][])listValues.toArray((T[])new byte[listValues.size()][]));
        this.setTTL(setObject, key);
    }

    private void addListsElement(JSONObject elementObject) {
        JSONArray listObjects = (JSONArray)elementObject.get((Object)LIST_TOKEN);
        for (Object object : listObjects) {
            JSONObject listObject = (JSONObject)object;
            this.addListElements(listObject);
        }
    }

    private void addListElements(JSONObject listObject) {
        JSONArray valuesArray = (JSONArray)listObject.get((Object)VALUES_TOKEN);
        List<byte[]> listValues = this.extractListOfValues(valuesArray);
        Object key = listObject.get((Object)KEY_TOKEN);
        this.jedis.rpush(JsonToJedisConverter.toByteArray(key), (byte[][])listValues.toArray((T[])new byte[listValues.size()][]));
        this.setTTL(listObject, key);
    }

    private List<byte[]> extractListOfValues(JSONArray valuesArray) {
        ArrayList<byte[]> listValues = new ArrayList<byte[]>();
        for (Object valueObject : valuesArray) {
            JSONObject jsonValueObject = (JSONObject)valueObject;
            listValues.add(JsonToJedisConverter.toByteArray(jsonValueObject.get((Object)VALUE_TOKEN)));
        }
        return listValues;
    }

    private void addSimpleValues(JSONObject elementObject) {
        JSONArray simpleElements = (JSONArray)elementObject.get((Object)SIMPLE_TOKEN);
        for (Object simpleElement : simpleElements) {
            JSONObject simpleElementObject = (JSONObject)simpleElement;
            Object key = simpleElementObject.get((Object)KEY_TOKEN);
            this.jedis.set(JsonToJedisConverter.toByteArray(key), JsonToJedisConverter.toByteArray(simpleElementObject.get((Object)VALUE_TOKEN)));
            this.setTTL(simpleElementObject, key);
        }
    }

    private void setTTL(JSONObject object, Object key) {
        if (object.containsKey((Object)EXPIRE_AT_SEC_TOKEN)) {
            Object expirationDate = object.get((Object)EXPIRE_AT_SEC_TOKEN);
            if (expirationDate instanceof Long) {
                this.jedis.expireAt(JsonToJedisConverter.toByteArray(key), ((Long)expirationDate).longValue());
            } else {
                throw new IllegalArgumentException("TTL expiration date should be a long value.");
            }
        }
        if (object.containsKey((Object)EXPIRE_SEC_TOKEN)) {
            Object expiration = object.get((Object)EXPIRE_SEC_TOKEN);
            if (expiration instanceof Long) {
                this.jedis.expire(JsonToJedisConverter.toByteArray(key), ((Long)expiration).intValue());
            } else {
                throw new IllegalArgumentException("TTL expiration date should be an integer value.");
            }
        }
    }
}

