/*
 * Decompiled with CFR 0.152.
 */
package com.luhuiguo.fastdfs.service;

import com.luhuiguo.fastdfs.conn.ConnectionManager;
import com.luhuiguo.fastdfs.domain.StorageNode;
import com.luhuiguo.fastdfs.domain.StorageNodeInfo;
import com.luhuiguo.fastdfs.domain.StorePath;
import com.luhuiguo.fastdfs.proto.storage.StorageAppendFileCommand;
import com.luhuiguo.fastdfs.proto.storage.StorageModifyCommand;
import com.luhuiguo.fastdfs.proto.storage.StorageTruncateCommand;
import com.luhuiguo.fastdfs.proto.storage.StorageUploadFileCommand;
import com.luhuiguo.fastdfs.service.AppendFileStorageClient;
import com.luhuiguo.fastdfs.service.DefaultGenerateStorageClient;
import com.luhuiguo.fastdfs.service.TrackerClient;
import java.io.InputStream;

public class DefaultAppendFileStorageClient
extends DefaultGenerateStorageClient
implements AppendFileStorageClient {
    public DefaultAppendFileStorageClient(TrackerClient trackerClient, ConnectionManager connectionManager) {
        super(trackerClient, connectionManager);
    }

    @Override
    public StorePath uploadAppenderFile(String groupName, InputStream inputStream, long fileSize, String fileExtName) {
        StorageNode client = this.trackerClient.getStoreStorage(groupName);
        StorageUploadFileCommand command = new StorageUploadFileCommand(client.getStoreIndex(), inputStream, fileExtName, fileSize, true);
        return this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), command);
    }

    @Override
    public void appendFile(String groupName, String path, InputStream inputStream, long fileSize) {
        StorageNodeInfo client = this.trackerClient.getUpdateStorage(groupName, path);
        StorageAppendFileCommand command = new StorageAppendFileCommand(inputStream, fileSize, path);
        this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), command);
    }

    @Override
    public void modifyFile(String groupName, String path, InputStream inputStream, long fileSize, long fileOffset) {
        StorageNodeInfo client = this.trackerClient.getUpdateStorage(groupName, path);
        StorageModifyCommand command = new StorageModifyCommand(path, inputStream, fileSize, fileOffset);
        this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), command);
    }

    @Override
    public void truncateFile(String groupName, String path, long truncatedFileSize) {
        StorageNodeInfo client = this.trackerClient.getUpdateStorage(groupName, path);
        StorageTruncateCommand command = new StorageTruncateCommand(path, truncatedFileSize);
        this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), command);
    }

    @Override
    public void truncateFile(String groupName, String path) {
        long truncatedFileSize = 0L;
        this.truncateFile(groupName, path, truncatedFileSize);
    }
}

