/*
 * Decompiled with CFR 0.152.
 */
package com.luhuiguo.fastdfs.service;

import com.luhuiguo.fastdfs.conn.ConnectionManager;
import com.luhuiguo.fastdfs.domain.MetaData;
import com.luhuiguo.fastdfs.domain.StorageNode;
import com.luhuiguo.fastdfs.domain.StorePath;
import com.luhuiguo.fastdfs.proto.storage.StorageSetMetadataCommand;
import com.luhuiguo.fastdfs.proto.storage.StorageUploadFileCommand;
import com.luhuiguo.fastdfs.proto.storage.enums.StorageMetdataSetType;
import com.luhuiguo.fastdfs.service.DefaultGenerateStorageClient;
import com.luhuiguo.fastdfs.service.FastFileStorageClient;
import com.luhuiguo.fastdfs.service.TrackerClient;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class DefaultFastFileStorageClient
extends DefaultGenerateStorageClient
implements FastFileStorageClient {
    public DefaultFastFileStorageClient(TrackerClient trackerClient, ConnectionManager connectionManager) {
        super(trackerClient, connectionManager);
    }

    @Override
    public StorePath uploadFile(InputStream inputStream, long fileSize, String fileExtName, Set<MetaData> metaDataSet) {
        Validate.notNull((Object)inputStream, (String)"\u4e0a\u4f20\u6587\u4ef6\u6d41\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fileExtName, (String)"\u6587\u4ef6\u6269\u5c55\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        StorageNode client = this.trackerClient.getStoreStorage();
        return this.uploadFileAndMetaData(client, inputStream, fileSize, fileExtName, metaDataSet);
    }

    private boolean hasMetaData(Set<MetaData> metaDataSet) {
        return null != metaDataSet && !metaDataSet.isEmpty();
    }

    private StorePath uploadFileAndMetaData(StorageNode client, InputStream inputStream, long fileSize, String fileExtName, Set<MetaData> metaDataSet) {
        StorageUploadFileCommand command = new StorageUploadFileCommand(client.getStoreIndex(), inputStream, fileExtName, fileSize, false);
        StorePath path = this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), command);
        if (this.hasMetaData(metaDataSet)) {
            StorageSetMetadataCommand setMDCommand = new StorageSetMetadataCommand(path.getGroup(), path.getPath(), metaDataSet, StorageMetdataSetType.STORAGE_SET_METADATA_FLAG_OVERWRITE);
            this.connectionManager.executeFdfsCmd(client.getInetSocketAddress(), setMDCommand);
        }
        return path;
    }

    @Override
    public void deleteFile(String filePath) {
        StorePath storePath = StorePath.praseFromUrl(filePath);
        super.deleteFile(storePath.getGroup(), storePath.getPath());
    }

    @Override
    public StorePath uploadFile(byte[] content, String fileExtName) {
        return this.uploadFile(new ByteArrayInputStream(content), content.length, fileExtName, null);
    }
}

