/*
 * Decompiled with CFR 0.152.
 */
package com.mtnfog.idyl.e3.sdk;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mtnfog.idyl.e3.sdk.model.Entity;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IdylE3Client {
    private static final Logger LOGGER = LogManager.getLogger(IdylE3Client.class);
    private static final int HTTP_OK = 200;
    private String endpoint;
    private Gson gson;
    private String userName;
    private String password;

    public IdylE3Client(String endpoint, String userName, String password) {
        this.endpoint = endpoint;
        this.userName = userName;
        this.password = password;
        this.gson = new Gson();
    }

    public void flush() throws IOException {
        String url = this.endpoint + "/flush";
        HttpResponse response = this.executeHttpPostRequest(url);
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode != 200) {
            LOGGER.warn("Unable to flush the integration batches. Check the Idyl E3 log for details.");
        }
    }

    public Map<String, Integer> getBatchSizes() throws IOException {
        Map<String, Integer> batchSizes = new HashMap<String, Integer>();
        String url = this.endpoint + "/batchsize";
        HttpResponse response = this.executeHttpGetRequest(url);
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode == 200) {
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String json = IOUtils.toString((Reader)rd);
            rd.close();
            batchSizes = (Map)this.gson.fromJson(json, new TypeToken<Map<String, Integer>>(){}.getType());
        } else {
            LOGGER.warn("Unable to retrieve the current batch sizes. Check the Idyl E3 log for details.");
        }
        return batchSizes;
    }

    public List<Entity> extractEntities(String text) throws IOException {
        return this.extractEntities(text, 0, false);
    }

    public List<Entity> extractEntities(String text, int confidence, boolean skipIntegrations) throws IOException {
        List entities = null;
        String completeEndpoint = this.endpoint + "/extract?text=%s&confidence=%s&skipIntegrations=%s";
        String encodedSentence = URLEncoder.encode(text, "UTF-8");
        String url = String.format(completeEndpoint, encodedSentence, confidence, String.valueOf(skipIntegrations));
        HttpResponse response = this.executeHttpPostRequest(url);
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode == 200) {
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String result = IOUtils.toString((Reader)rd);
            rd.close();
            entities = (List)this.gson.fromJson(result.toString(), new TypeToken<List<Entity>>(){}.getType());
        } else {
            LOGGER.warn("Unable to extract entities. Check the Idyl E3 log for details.");
        }
        return entities;
    }

    private String generateHttpAuthorizationHeaderValue() {
        return "Basic " + Base64.encodeBase64String((byte[])(this.userName + ":" + this.password).getBytes());
    }

    private HttpResponse executeHttpPostRequest(String url) throws IOException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost request = new HttpPost(url);
        request.addHeader("Accept", "application/json");
        request.addHeader("Authorization", this.generateHttpAuthorizationHeaderValue());
        return client.execute((HttpUriRequest)request);
    }

    private HttpResponse executeHttpGetRequest(String url) throws IOException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet request = new HttpGet(url);
        request.addHeader("Accept", "application/json");
        request.addHeader("Authorization", this.generateHttpAuthorizationHeaderValue());
        return client.execute((HttpUriRequest)request);
    }
}

