/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.Constant;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.Visitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ConstantImpl<T>
extends ExpressionBase<T>
implements Constant<T> {
    private static final long serialVersionUID = -3898138057967814118L;
    private static final int CACHE_SIZE = 256;
    private static final Constant<Character>[] CHARACTERS = new Constant[256];
    private static final Constant<Byte>[] BYTES = new Constant[256];
    private static final Constant<Integer>[] INTEGERS = new Constant[256];
    private static final Constant<Long>[] LONGS = new Constant[256];
    private static final Constant<Short>[] SHORTS = new Constant[256];
    private static final Map<String, Constant<String>> STRINGS;
    private static final Constant<Boolean> FALSE;
    private static final Constant<Boolean> TRUE;
    private final T constant;

    public static Constant<Boolean> create(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static Constant<Byte> create(byte i) {
        if (i >= 0 && i < 256) {
            return BYTES[i];
        }
        return new ConstantImpl<Byte>(Byte.class, i);
    }

    public static Constant<Character> create(char i) {
        if (i >= '\u0000' && i < '\u0100') {
            return CHARACTERS[i];
        }
        return new ConstantImpl<Character>(Character.class, Character.valueOf(i));
    }

    public static Constant<Integer> create(int i) {
        if (i >= 0 && i < 256) {
            return INTEGERS[i];
        }
        return new ConstantImpl<Integer>(Integer.class, i);
    }

    public static Constant<Long> create(long i) {
        if (i >= 0L && i < 256L) {
            return LONGS[(int)i];
        }
        return new ConstantImpl<Long>(Long.class, i);
    }

    public static Constant<Short> create(short i) {
        if (i >= 0 && i < 256) {
            return SHORTS[i];
        }
        return new ConstantImpl<Short>(Short.class, i);
    }

    public static Constant<String> create(String str) {
        return ConstantImpl.create(str, false);
    }

    public static Constant<String> create(String str, boolean populateCache) {
        if (STRINGS.containsKey(str)) {
            return STRINGS.get(str);
        }
        ConstantImpl<Object> rv = new ConstantImpl<Object>(Assert.notNull((Object)str, (String)"str"));
        if (populateCache) {
            STRINGS.put(str, rv);
        }
        return rv;
    }

    public static <T> Constant<Class<T>> create(Class<T> constant) {
        return new ConstantImpl<Class<T>>(constant);
    }

    public ConstantImpl(T constant) {
        this(constant.getClass(), constant);
    }

    public ConstantImpl(Class<T> type, T constant) {
        super(type);
        this.constant = constant;
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Constant) {
            return ((Constant)o).getConstant().equals(this.constant);
        }
        return false;
    }

    @Override
    public T getConstant() {
        return this.constant;
    }

    static {
        FALSE = new ConstantImpl<Boolean>(Boolean.FALSE);
        TRUE = new ConstantImpl<Boolean>(Boolean.TRUE);
        ArrayList<String> strs = new ArrayList<String>(Arrays.asList("", ".", ".*", "%"));
        for (int i = 0; i < 256; ++i) {
            strs.add(String.valueOf(i));
        }
        STRINGS = new HashMap<String, Constant<String>>(strs.size());
        for (String str : strs) {
            STRINGS.put(str, new ConstantImpl<String>(str));
        }
        for (int i = 0; i < 256; ++i) {
            ConstantImpl.INTEGERS[i] = new ConstantImpl<Integer>(Integer.class, i);
            ConstantImpl.SHORTS[i] = new ConstantImpl<Short>(Short.class, (short)i);
            ConstantImpl.BYTES[i] = new ConstantImpl<Byte>(Byte.class, (byte)i);
            ConstantImpl.CHARACTERS[i] = new ConstantImpl<Character>(Character.class, Character.valueOf((char)i));
            ConstantImpl.LONGS[i] = new ConstantImpl<Long>(Long.class, Long.valueOf(i));
        }
    }
}

