/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Visitor;
import java.util.UUID;

public class ParamExpressionImpl<T>
extends ExpressionBase<T>
implements ParamExpression<T> {
    private static final long serialVersionUID = -6872502615009012503L;
    private final String name;
    private final boolean anon;

    public ParamExpressionImpl(Class<? extends T> type, String name) {
        super(type);
        this.name = (String)Assert.notNull((Object)name, (String)"name");
        this.anon = false;
    }

    public ParamExpressionImpl(Class<? extends T> type) {
        super(type);
        this.name = UUID.randomUUID().toString().replace("-", "").substring(0, 10);
        this.anon = true;
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ParamExpression) {
            ParamExpression other = (ParamExpression)o;
            return other.getType().equals(this.getType()) && other.getName().equals(this.name) && other.isAnon() == this.anon;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAnon() {
        return this.anon;
    }

    @Override
    public String getNotSetMessage() {
        if (!this.anon) {
            return "The parameter " + this.name + " needs to be set";
        }
        return "A parameter of type " + this.getType().getName() + " was not set";
    }
}

