/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.DslExpression;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import java.util.Collection;
import javax.annotation.Nullable;

public abstract class CollectionExpressionBase<T extends Collection<E>, E>
extends DslExpression<T>
implements CollectionExpression<T, E> {
    private static final long serialVersionUID = 691230660037162054L;
    @Nullable
    private volatile BooleanExpression empty;
    @Nullable
    private volatile NumberExpression<Integer> size;

    public CollectionExpressionBase(Expression<T> mixin) {
        super(mixin);
    }

    public final BooleanExpression contains(E child) {
        return this.contains((Expression<E>)new ConstantImpl<E>(child));
    }

    public final BooleanExpression contains(Expression<E> child) {
        return BooleanOperation.create(Ops.IN, child, this);
    }

    public abstract Class<E> getElementType();

    public final BooleanExpression isEmpty() {
        if (this.empty == null) {
            this.empty = BooleanOperation.create(Ops.COL_IS_EMPTY, this);
        }
        return this.empty;
    }

    public final BooleanExpression isNotEmpty() {
        return this.isEmpty().not();
    }

    public final NumberExpression<Integer> size() {
        if (this.size == null) {
            this.size = NumberOperation.create(Integer.class, Ops.COL_SIZE, this);
        }
        return this.size;
    }
}

