/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.BooleanBuilder;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.path.SimplePath;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class ForeignKey<E>
implements Serializable {
    private static final long serialVersionUID = 2260578033772289023L;
    private final RelationalPath<?> entity;
    private final List<? extends Path<?>> localColumns;
    private final List<String> foreignColumns;

    public ForeignKey(RelationalPath<?> entity, Path<?> localColumn, String foreignColumn) {
        this(entity, Arrays.asList(localColumn), Arrays.asList(foreignColumn));
    }

    public ForeignKey(RelationalPath<?> entity, List<? extends Path<?>> localColumns, List<String> foreignColumns) {
        this.entity = entity;
        this.localColumns = localColumns;
        this.foreignColumns = foreignColumns;
    }

    public RelationalPath<?> getEntity() {
        return this.entity;
    }

    public List<? extends Path<?>> getLocalColumns() {
        return this.localColumns;
    }

    public List<String> getForeignColumns() {
        return this.foreignColumns;
    }

    public Predicate on(RelationalPath<E> entity) {
        BooleanBuilder builder = new BooleanBuilder();
        for (int i = 0; i < this.localColumns.size(); ++i) {
            Expression local = (Expression)this.localColumns.get(i);
            SimplePath foreign = new SimplePath(local.getType(), entity, this.foreignColumns.get(i));
            builder.and(ExpressionUtils.eq((Expression)local, (Expression)foreign));
        }
        return builder.getValue();
    }
}

