/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.sql.Beans;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.QBean;
import com.mysema.query.types.Visitor;
import com.mysema.util.ArrayUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QBeans
extends ExpressionBase<Beans>
implements FactoryExpression<Beans> {
    private static final long serialVersionUID = -4411839816134215923L;
    private final Map<RelationalPath<?>, QBean<?>> qBeans = new LinkedHashMap();
    private final List<Expression<?>> expressions = new ArrayList();

    public QBeans(RelationalPath<?> ... beanPaths) {
        super(Beans.class);
        try {
            for (RelationalPath<?> path : beanPaths) {
                LinkedHashMap<String, Expression> bindings = new LinkedHashMap<String, Expression>();
                for (Field field : path.getClass().getFields()) {
                    if (!Expression.class.isAssignableFrom(field.getType()) || Modifier.isStatic(field.getModifiers())) continue;
                    field.setAccessible(true);
                    Expression column = (Expression)field.get(path);
                    bindings.put(field.getName(), column);
                    this.expressions.add(column);
                }
                this.qBeans.put(path, new QBean(path.getType(), bindings));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public <R, C> R accept(Visitor<R, C> v, C context) {
        return (R)v.visit((FactoryExpression)this, context);
    }

    public List<Expression<?>> getArgs() {
        return this.expressions;
    }

    public Beans newInstance(Object ... args) {
        int offset = 0;
        HashMap beans = new HashMap();
        for (Map.Entry<RelationalPath<?>, QBean<?>> entry : this.qBeans.entrySet()) {
            RelationalPath<?> path = entry.getKey();
            QBean<?> qBean = entry.getValue();
            int argsSize = qBean.getArgs().size();
            Object[] subArgs = ArrayUtils.subarray((Object[])args, (int)offset, (int)(offset + argsSize));
            beans.put(path, qBean.newInstance(subArgs));
            offset += argsSize;
        }
        return new Beans(beans);
    }
}

