/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.util;

import java.util.concurrent.atomic.AtomicLong;

public class MeasuredRate {
    private final AtomicLong _lastBucket = new AtomicLong(0L);
    private final AtomicLong _currentBucket = new AtomicLong(0L);
    private final long _sampleInterval;
    private volatile long _threshold;

    public MeasuredRate(long sampleInterval) {
        this._sampleInterval = sampleInterval;
        this._threshold = System.currentTimeMillis() + sampleInterval;
    }

    public long getCount() {
        this.checkAndResetWindow();
        return this._lastBucket.get();
    }

    public long getCurrentCount() {
        this.checkAndResetWindow();
        return this._currentBucket.get();
    }

    public void increment() {
        this.checkAndResetWindow();
        this._currentBucket.incrementAndGet();
    }

    private void checkAndResetWindow() {
        long now = System.currentTimeMillis();
        if (this._threshold < now) {
            this._lastBucket.set(this._currentBucket.get());
            this._currentBucket.set(0L);
            this._threshold = now + this._sampleInterval;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("count:" + this.getCount());
        sb.append("currentCount:" + this.getCurrentCount());
        return sb.toString();
    }

    public static void main(String[] args) {
        MeasuredRate mr = new MeasuredRate(500L);
        for (int i = 0; i < 1000; ++i) {
            mr.increment();
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("mr:" + mr);
    }
}

