/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;

public final class BlockingOperatorMostRecent {
    public static <T> Iterable<T> mostRecent(final Observable<? extends T> source, final T initialValue) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                MostRecentObserver mostRecentObserver = new MostRecentObserver(initialValue);
                MostRecentIterator nextIterator = new MostRecentIterator(mostRecentObserver);
                source.subscribe(mostRecentObserver);
                return nextIterator;
            }
        };
    }

    private static class MostRecentObserver<T>
    extends Subscriber<T> {
        private final AtomicBoolean completed = new AtomicBoolean(false);
        private final AtomicReference<T> value;
        private final AtomicReference<Throwable> exception = new AtomicReference();

        private MostRecentObserver(T value) {
            this.value = new AtomicReference<T>(value);
        }

        @Override
        public void onCompleted() {
            this.completed.set(true);
        }

        @Override
        public void onError(Throwable e) {
            this.exception.set(e);
        }

        @Override
        public void onNext(T args) {
            this.value.set(args);
        }

        private boolean isCompleted() {
            return this.completed.get();
        }

        private Throwable getThrowable() {
            return this.exception.get();
        }

        private T getRecentValue() {
            return this.value.get();
        }
    }

    private static class MostRecentIterator<T>
    implements Iterator<T> {
        private final MostRecentObserver<T> observer;

        private MostRecentIterator(MostRecentObserver<T> observer) {
            this.observer = observer;
        }

        @Override
        public boolean hasNext() {
            return !((MostRecentObserver)this.observer).isCompleted();
        }

        @Override
        public T next() {
            if (((MostRecentObserver)this.observer).getThrowable() != null) {
                throw Exceptions.propagate(((MostRecentObserver)this.observer).getThrowable());
            }
            return (T)((MostRecentObserver)this.observer).getRecentValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read only iterator");
        }
    }
}

